/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.net;

import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class AddressInitializations {
    AddressInitializations() {
    }

    static InetAddress computeDefaultAdvertisedHost() {
        return AddressInitializations.computeDefaultAdvertisedHost(NetUtil.NETWORK_INTERFACES.stream().flatMap(NetworkInterface::inetAddresses), InetAddress::getLocalHost, NetUtil.isIpV6AddressesPreferred());
    }

    static InetAddress computeDefaultAdvertisedHost(Stream<InetAddress> addresses, LocalHostSupplier localhost, boolean isIPv6Preferred) {
        try {
            return localhost.get();
        }
        catch (UnknownHostException unknownHostException) {
            NonLoopBackAddresses nonLoopBackAddresses = AddressInitializations.collectNonLoopBackAddresses(addresses, isIPv6Preferred);
            InetAddress nonLoopBackAddress = nonLoopBackAddresses.address();
            if (nonLoopBackAddress != null) {
                return nonLoopBackAddress;
            }
            if (isIPv6Preferred) {
                return NetUtil.LOCALHOST6;
            }
            return NetUtil.LOCALHOST4;
        }
    }

    private static NonLoopBackAddresses collectNonLoopBackAddresses(Stream<InetAddress> networkInterfaces, boolean isIPv6Preferred) {
        return networkInterfaces.filter(Predicate.not(InetAddress::isLoopbackAddress)).collect(() -> new NonLoopBackAddresses(isIPv6Preferred), NonLoopBackAddresses::setIfNonNull, (a, b) -> {
            a.setIfNonNull(b.ipv4);
            a.setIfNonNull(b.ipv6);
        });
    }

    @FunctionalInterface
    static interface LocalHostSupplier {
        public InetAddress get() throws UnknownHostException;
    }

    private static final class NonLoopBackAddresses {
        private final boolean isIPv6Preferred;
        private InetAddress ipv4;
        private InetAddress ipv6;

        private NonLoopBackAddresses(boolean isIPv6Preferred) {
            this.isIPv6Preferred = isIPv6Preferred;
        }

        private void setIfNonNull(InetAddress address) {
            if (NetUtil.isValidIpV6Address((String)address.getHostAddress())) {
                if (this.ipv6 == null) {
                    this.ipv6 = address;
                }
                return;
            }
            if (this.ipv4 == null) {
                this.ipv4 = address;
            }
        }

        private InetAddress address() {
            if (this.isIPv6Preferred) {
                return this.ipv6 != null ? this.ipv6 : this.ipv4;
            }
            return this.ipv4 != null ? this.ipv4 : this.ipv6;
        }
    }
}

