/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import io.camunda.zeebe.auth.api.AuthorizationDecoder;
import io.camunda.zeebe.auth.api.JwtAuthorizationBuilder;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthorizationDecoder
implements JwtAuthorizationBuilder<JwtAuthorizationDecoder, Algorithm, DecodedJWT>,
AuthorizationDecoder<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthorizationDecoder.class);
    private String issuer = "zeebe-gateway";
    private String audience = "zeebe-broker";
    private String subject = "zeebe-client";
    private Algorithm signingAlgorithm = Algorithm.none();
    private final Set<String> claims = new HashSet<String>();
    private String jwtToken;

    public JwtAuthorizationDecoder() {
    }

    public JwtAuthorizationDecoder(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    @Override
    public JwtAuthorizationDecoder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public JwtAuthorizationDecoder withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Override
    public JwtAuthorizationDecoder withAudience(String audience) {
        this.audience = audience;
        return this;
    }

    @Override
    public JwtAuthorizationDecoder withSigningAlgorithm(Algorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    @Override
    public DecodedJWT build() {
        Verification verificationBuilder = JWT.require((Algorithm)this.signingAlgorithm).withIssuer(this.issuer).withAudience(new String[]{this.audience}).withSubject(this.subject);
        for (String claim : this.claims) {
            verificationBuilder.withClaimPresence(claim);
        }
        JWTVerifier jwtVerification = verificationBuilder.build();
        try {
            return jwtVerification.verify(this.jwtToken);
        }
        catch (JWTVerificationException | NullPointerException ex) {
            LOGGER.error("Authorization data unavailable: {}", (Object)ex.getMessage());
            throw new UnrecoverableException("Authorization data unavailable: " + ex.getMessage(), ex);
        }
    }

    @Override
    public Map<String, Object> decode() {
        DecodedJWT decodedJWT = this.withClaim("authorized_tenants").build();
        return Map.of("authorized_tenants", decodedJWT.getClaim("authorized_tenants").asList(String.class));
    }

    public JwtAuthorizationDecoder withClaim(String claimName) {
        this.claims.add(claimName);
        return this;
    }

    public JwtAuthorizationDecoder withJwtToken(String token) {
        this.jwtToken = token;
        return this;
    }
}

