/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs.manifest;

import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.gcs.GcsBackupStoreException;
import io.camunda.zeebe.backup.gcs.manifest.FileSet;
import io.camunda.zeebe.backup.gcs.manifest.Manifest;
import java.time.Instant;

record ManifestImpl(BackupIdentifierImpl id, BackupDescriptorImpl descriptor, Manifest.StatusCode statusCode, FileSet snapshot, FileSet segments, Instant createdAt, Instant modifiedAt, String failureReason) implements Manifest.InProgressManifest,
Manifest.CompletedManifest,
Manifest.FailedManifest
{
    public static final String ERROR_MSG_WRONG_STATE = "Expected a failed Manifest to set failureReason '%s', but was in state '%s'.";

    ManifestImpl {
        if (failureReason != null && statusCode != Manifest.StatusCode.FAILED) {
            throw new GcsBackupStoreException.InvalidPersistedManifestState(ERROR_MSG_WRONG_STATE.formatted(new Object[]{failureReason, statusCode}));
        }
    }

    ManifestImpl(BackupIdentifierImpl id, BackupDescriptorImpl descriptor, Manifest.StatusCode statusCode, FileSet snapshot, FileSet segments, Instant createdAt, Instant modifiedAt) {
        this(id, descriptor, statusCode, snapshot, segments, createdAt, modifiedAt, null);
    }

    @Override
    public Manifest.CompletedManifest complete() {
        return new ManifestImpl(this.id, this.descriptor, Manifest.StatusCode.COMPLETED, this.snapshot, this.segments, this.createdAt, Instant.now());
    }

    @Override
    public Manifest.FailedManifest fail(String failureReason) {
        return new ManifestImpl(this.id, this.descriptor, Manifest.StatusCode.FAILED, this.snapshot, this.segments, this.createdAt, Instant.now(), failureReason);
    }

    @Override
    public Manifest.InProgressManifest asInProgress() {
        if (this.statusCode != Manifest.StatusCode.IN_PROGRESS) {
            throw new GcsBackupStoreException.UnexpectedManifestState(Manifest.StatusCode.IN_PROGRESS, this.statusCode);
        }
        return this;
    }

    @Override
    public Manifest.CompletedManifest asCompleted() {
        if (this.statusCode != Manifest.StatusCode.COMPLETED) {
            throw new GcsBackupStoreException.UnexpectedManifestState(Manifest.StatusCode.COMPLETED, this.statusCode);
        }
        return this;
    }

    @Override
    public Manifest.FailedManifest asFailed() {
        if (this.statusCode != Manifest.StatusCode.FAILED) {
            throw new GcsBackupStoreException.UnexpectedManifestState(Manifest.StatusCode.FAILED, this.statusCode);
        }
        return this;
    }
}

