/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs.manifest;

import io.camunda.zeebe.backup.api.NamedFileSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public record FileSet(List<NamedFile> files) {
    public static final String ERROR_MSG_UNIQUE_FILES = "Expected file name '%s' to be unique, but occurred '%s' times in %s";

    public FileSet {
        Objects.requireNonNull(files);
        Map<String, Long> countByName = files.stream().collect(Collectors.groupingBy(NamedFile::name, Collectors.counting()));
        for (Map.Entry<String, Long> occurrence : countByName.entrySet()) {
            if (occurrence.getValue() <= 1L) continue;
            throw new IllegalArgumentException(ERROR_MSG_UNIQUE_FILES.formatted(occurrence.getKey(), occurrence.getValue(), files));
        }
    }

    static FileSet of(NamedFileSet fileSet) {
        if (fileSet == null) {
            return new FileSet(List.of());
        }
        return new FileSet(fileSet.namedFiles().keySet().stream().map(NamedFile::new).toList());
    }

    public record NamedFile(String name) {
        public NamedFile {
            Objects.requireNonNull(name);
        }
    }
}

