/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.util;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAggregatingSubscriber<T>
implements Subscriber<CompletableFuture<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncAggregatingSubscriber.class);
    final ConcurrentLinkedDeque<T> results = new ConcurrentLinkedDeque();
    final CompletableFuture<Collection<T>> resultsFuture = new CompletableFuture();
    final Phaser phaser = new Phaser(1);
    private Subscription subscription;
    private final long parallelism;

    public AsyncAggregatingSubscriber(long parallelism) {
        this.parallelism = parallelism;
    }

    public void onSubscribe(Subscription subscription) {
        LOG.trace("Subscription started");
        this.phaser.register();
        this.subscription = subscription;
        subscription.request(this.parallelism);
    }

    public void onNext(CompletableFuture<T> future) {
        LOG.trace("Received next future: {}", future);
        this.phaser.register();
        future.handleAsync((result, throwable) -> {
            if (throwable == null) {
                LOG.trace("Completed: {}", result);
                this.results.add(result);
                if (this.phaser.arrive() >= 0) {
                    this.subscription.request(1L);
                }
            } else {
                LOG.trace("Future failed.", throwable);
                this.resultsFuture.completeExceptionally((Throwable)throwable);
                this.phaser.forceTermination();
                this.subscription.cancel();
            }
            return null;
        });
    }

    public void onError(Throwable t) {
        LOG.trace("Subscription failed.", t);
        this.resultsFuture.completeExceptionally(t);
        this.phaser.forceTermination();
    }

    public void onComplete() {
        LOG.trace("Completed subscription");
        this.phaser.arrive();
    }

    public CompletableFuture<Collection<T>> result() {
        return CompletableFuture.supplyAsync(this.phaser::arriveAndAwaitAdvance).thenCompose(ignored -> {
            this.resultsFuture.complete(this.results);
            return this.resultsFuture;
        });
    }
}

