/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public record S3BackupConfig(String bucketName, Optional<String> endpoint, Optional<String> region, Optional<Credentials> credentials, Optional<Duration> apiCallTimeout, boolean forcePathStyleAccess, Optional<String> compressionAlgorithm, Optional<String> basePath, Integer maxConcurrentConnections, Duration connectionAcquisitionTimeout) {
    public S3BackupConfig {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("Bucket name must not be empty.");
        }
        if (compressionAlgorithm.isPresent()) {
            Set inputAlgorithms = CompressorStreamFactory.getSingleton().getInputStreamCompressorNames();
            Set outputAlgorithms = CompressorStreamFactory.getSingleton().getOutputStreamCompressorNames();
            HashSet supported = new HashSet(inputAlgorithms);
            supported.retainAll(outputAlgorithms);
            if (!supported.contains(compressionAlgorithm.get())) {
                throw new IllegalArgumentException("Can't use compression algorithm %s. Only supports %s".formatted(compressionAlgorithm.get(), supported));
            }
        }
        if (basePath.isPresent()) {
            String prefix = basePath.get();
            if (prefix.isEmpty()) {
                throw new IllegalArgumentException("basePath is set but empty. It must be either unset or not empty.");
            }
            if (prefix.startsWith("/") || prefix.endsWith("/")) {
                throw new IllegalArgumentException("basePath must not start or end with '/' but was: %s".formatted(prefix));
            }
        }
    }

    public static class Builder {
        private String bucketName;
        private String endpoint;
        private String region;
        private Duration apiCallTimeoutMs;
        private boolean forcePathStyleAccess = false;
        private String compressionAlgorithm;
        private Credentials credentials;
        private String basePath;
        private Integer maxConcurrentConnections = 50;
        private Duration connectionAcquisitionTimeout = Duration.ofSeconds(45L);

        public Builder withBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withCredentials(String accessKey, String secretKey) {
            this.credentials = new Credentials(accessKey, secretKey);
            return this;
        }

        public Builder withApiCallTimeout(Duration apiCallTimeoutMs) {
            this.apiCallTimeoutMs = apiCallTimeoutMs;
            return this;
        }

        public Builder forcePathStyleAccess(boolean forcePathStyleAccess) {
            this.forcePathStyleAccess = forcePathStyleAccess;
            return this;
        }

        public Builder withCompressionAlgorithm(String compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withParallelUploadsLimit(Integer parallelUploadsLimit) {
            this.maxConcurrentConnections = parallelUploadsLimit;
            return this;
        }

        public Builder withConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
            return this;
        }

        public S3BackupConfig build() {
            return new S3BackupConfig(this.bucketName, Optional.ofNullable(this.endpoint), Optional.ofNullable(this.region), Optional.ofNullable(this.credentials), Optional.ofNullable(this.apiCallTimeoutMs), this.forcePathStyleAccess, Optional.ofNullable(this.compressionAlgorithm), Optional.ofNullable(this.basePath), this.maxConcurrentConnections, this.connectionAcquisitionTimeout);
        }
    }

    record Credentials(String accessKey, String secretKey) {
        @Override
        public String toString() {
            return "Credentials{accessKey='" + this.accessKey + "', secretKey='<redacted>'}";
        }
    }
}

