/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class CompletableFutureUtils {
    private CompletableFutureUtils() {
    }

    public static <K, V> CompletableFuture<Map<K, V>> mapAsync(Collection<K> keys, Function<K, CompletableFuture<V>> valueMapper) {
        return CompletableFutureUtils.mapAsync(keys, Function.identity(), valueMapper);
    }

    public static <C, K, V> CompletableFuture<Map<K, V>> mapAsync(Collection<C> coll, Function<C, K> keyMapper, Function<C, CompletableFuture<V>> valueMapper) {
        Map inProgress = coll.stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return CompletableFuture.allOf((CompletableFuture[])inProgress.values().toArray(CompletableFuture[]::new)).thenApply(unused -> inProgress.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CompletableFuture)entry.getValue()).join())));
    }
}

