/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3;

import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.s3.manifest.Manifest;

public abstract sealed class S3BackupStoreException
extends RuntimeException {
    private S3BackupStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    public static final class BackupCompressionFailed
    extends S3BackupStoreException {
        public BackupCompressionFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class BackupDeletionIncomplete
    extends S3BackupStoreException {
        public BackupDeletionIncomplete(String message) {
            super(message, null);
        }
    }

    public static final class BackupInInvalidStateException
    extends S3BackupStoreException {
        public BackupInInvalidStateException(String message) {
            super(message, null);
        }

        public BackupInInvalidStateException(Manifest manifest, BackupStatusCode expectedStatus) {
            this("Expected %s to be %s but was %s".formatted(manifest.id(), expectedStatus, manifest.statusCode()));
        }
    }

    public static final class BackupReadException
    extends S3BackupStoreException {
        public BackupReadException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class ManifestParseException
    extends S3BackupStoreException {
        public ManifestParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

