/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.processing;

import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.backup.metrics.CheckpointMetrics;
import io.camunda.zeebe.backup.processing.CheckpointCreateProcessor;
import io.camunda.zeebe.backup.processing.CheckpointCreatedEventApplier;
import io.camunda.zeebe.backup.processing.state.DbCheckpointState;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import io.camunda.zeebe.stream.api.ProcessingResult;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.RecordProcessor;
import io.camunda.zeebe.stream.api.RecordProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckpointRecordsProcessor
implements RecordProcessor,
StreamProcessorLifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointRecordsProcessor.class);
    private final BackupManager backupManager;
    private CheckpointCreateProcessor checkpointCreateProcessor;
    private CheckpointCreatedEventApplier checkpointCreatedEventApplier;
    private final Set<CheckpointListener> checkpointListeners = new CopyOnWriteArraySet<CheckpointListener>();
    private final CheckpointMetrics metrics;
    private DbCheckpointState checkpointState;
    private ProcessingScheduleService executor;

    public CheckpointRecordsProcessor(BackupManager backupManager, int partitionId) {
        this.backupManager = backupManager;
        this.metrics = new CheckpointMetrics(partitionId);
    }

    public void init(RecordProcessorContext recordProcessorContext) {
        this.executor = recordProcessorContext.getScheduleService();
        this.checkpointState = new DbCheckpointState((ZeebeDb<ZbColumnFamilies>)recordProcessorContext.getZeebeDb(), recordProcessorContext.getTransactionContext());
        this.checkpointCreateProcessor = new CheckpointCreateProcessor(this.checkpointState, this.backupManager, this.checkpointListeners, this.metrics);
        this.checkpointCreatedEventApplier = new CheckpointCreatedEventApplier(this.checkpointState, this.checkpointListeners, this.metrics);
        long checkpointId = this.checkpointState.getCheckpointId();
        if (checkpointId != -1L) {
            this.checkpointListeners.forEach(listener -> listener.onNewCheckpointCreated(checkpointId));
            this.metrics.setCheckpointId(checkpointId, this.checkpointState.getCheckpointPosition());
        }
        recordProcessorContext.addLifecycleListeners(List.of(this));
    }

    public boolean accepts(ValueType valueType) {
        return valueType == ValueType.CHECKPOINT;
    }

    public void replay(TypedRecord record) {
        if (record.getValueType() != ValueType.CHECKPOINT) {
            throw new IllegalArgumentException("Unknown record");
        }
        CheckpointIntent intent = (CheckpointIntent)record.getIntent();
        if (intent == CheckpointIntent.CREATED) {
            this.checkpointCreatedEventApplier.apply((CheckpointRecord)record.getValue());
        }
    }

    public ProcessingResult process(TypedRecord record, ProcessingResultBuilder resultBuilder) {
        if (record.getValueType() == ValueType.CHECKPOINT && record.getIntent() == CheckpointIntent.CREATE) {
            return this.checkpointCreateProcessor.process((TypedRecord<CheckpointRecord>)record, resultBuilder);
        }
        throw new IllegalArgumentException("Unknown record");
    }

    public ProcessingResult onProcessingError(Throwable processingException, TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        LOG.error("Could not process checkpoint record {}.", (Object)record.getValue(), (Object)processingException);
        throw new RuntimeException(processingException);
    }

    public void addCheckpointListener(CheckpointListener checkpointListener) {
        this.checkpointListeners.add(checkpointListener);
        if (this.executor != null) {
            this.executor.runDelayed(Duration.ZERO, () -> {
                long checkpointId = this.checkpointState.getCheckpointId();
                if (checkpointId != -1L) {
                    checkpointListener.onNewCheckpointCreated(this.checkpointState.getCheckpointId());
                }
            });
        }
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.backupManager.failInProgressBackup(this.checkpointState.getCheckpointId());
    }
}

