/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.processing;

import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.backup.metrics.CheckpointMetrics;
import io.camunda.zeebe.backup.processing.state.CheckpointState;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import java.util.Set;

public final class CheckpointCreatedEventApplier {
    private final CheckpointState checkpointState;
    private final Set<CheckpointListener> checkpointListeners;
    private final CheckpointMetrics metrics;

    public CheckpointCreatedEventApplier(CheckpointState checkpointState, Set<CheckpointListener> checkpointListeners, CheckpointMetrics metrics) {
        this.checkpointState = checkpointState;
        this.checkpointListeners = checkpointListeners;
        this.metrics = metrics;
    }

    public void apply(CheckpointRecord checkpointRecord) {
        this.checkpointState.setCheckpointInfo(checkpointRecord.getCheckpointId(), checkpointRecord.getCheckpointPosition());
        this.checkpointListeners.forEach(listener -> listener.onNewCheckpointCreated(this.checkpointState.getCheckpointId()));
    }
}

