/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.processing.state;

import io.camunda.zeebe.backup.processing.state.CheckpointInfo;
import io.camunda.zeebe.backup.processing.state.CheckpointState;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public final class DbCheckpointState
implements CheckpointState {
    private static final String CHECKPOINT_KEY = "checkpoint";
    private final CheckpointInfo checkpointInfo = new CheckpointInfo();
    private final ColumnFamily<DbString, CheckpointInfo> checkpointColumnFamily;
    private final DbString checkpointInfoKey = new DbString();

    public DbCheckpointState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.checkpointInfoKey.wrapString(CHECKPOINT_KEY);
        this.checkpointColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEFAULT, transactionContext, (DbKey)this.checkpointInfoKey, (DbValue)this.checkpointInfo);
    }

    @Override
    public long getCheckpointId() {
        CheckpointInfo info = (CheckpointInfo)this.checkpointColumnFamily.get((DbKey)this.checkpointInfoKey);
        return info != null ? info.getId() : -1L;
    }

    @Override
    public long getCheckpointPosition() {
        CheckpointInfo info = (CheckpointInfo)this.checkpointColumnFamily.get((DbKey)this.checkpointInfoKey);
        return info != null ? info.getPosition() : -1L;
    }

    @Override
    public void setCheckpointInfo(long checkpointId, long checkpointPosition) {
        this.checkpointInfo.setId(checkpointId).setPosition(checkpointPosition);
        this.checkpointColumnFamily.upsert((DbKey)this.checkpointInfoKey, (DbValue)this.checkpointInfo);
    }
}

