/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.camunda.zeebe.backup.metrics.BackupManagerMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class BackupManagerMetrics {
    private final MeterRegistry registry;
    private final Table<BackupManagerMetricsDoc.OperationType, BackupManagerMetricsDoc.OperationResult, Counter> totalOperations = Table.ofEnum(BackupManagerMetricsDoc.OperationType.class, BackupManagerMetricsDoc.OperationResult.class, Counter[]::new);
    private final Map<BackupManagerMetricsDoc.OperationType, AtomicLong> operationInProgress = new EnumMap<BackupManagerMetricsDoc.OperationType, AtomicLong>(BackupManagerMetricsDoc.OperationType.class);
    private final Map<BackupManagerMetricsDoc.OperationType, Timer> backupOperationLatency = new EnumMap<BackupManagerMetricsDoc.OperationType, Timer>(BackupManagerMetricsDoc.OperationType.class);

    public BackupManagerMetrics(MeterRegistry meterRegistry) {
        this.registry = Objects.requireNonNull(meterRegistry, "meterRegistry cannot be null");
    }

    public OperationMetrics startTakingBackup() {
        return this.start(BackupManagerMetricsDoc.OperationType.TAKE);
    }

    public OperationMetrics startQueryingStatus() {
        return this.start(BackupManagerMetricsDoc.OperationType.STATUS);
    }

    public OperationMetrics startListingBackups() {
        return this.start(BackupManagerMetricsDoc.OperationType.LIST);
    }

    public OperationMetrics startDeleting() {
        return this.start(BackupManagerMetricsDoc.OperationType.DELETE);
    }

    public void cancelInProgressOperations() {
        for (BackupManagerMetricsDoc.OperationType operation : BackupManagerMetricsDoc.OperationType.values()) {
            AtomicLong value = this.operationInProgress.get((Object)operation);
            if (value == null) continue;
            value.set(0L);
        }
    }

    private Counter registerTotalOperation(BackupManagerMetricsDoc.OperationType operation, BackupManagerMetricsDoc.OperationResult result) {
        return Counter.builder((String)BackupManagerMetricsDoc.BACKUP_OPERATIONS_TOTAL.getName()).description(BackupManagerMetricsDoc.BACKUP_OPERATIONS_TOTAL.getDescription()).tags(new String[]{BackupManagerMetricsDoc.MetricKeyName.OPERATION.asString(), operation.getValue(), BackupManagerMetricsDoc.MetricKeyName.RESULT.asString(), result.getValue()}).register(this.registry);
    }

    private Timer registerBackupLatency(BackupManagerMetricsDoc.OperationType operationType) {
        return Timer.builder((String)BackupManagerMetricsDoc.BACKUP_OPERATIONS_LATENCY.getName()).description(BackupManagerMetricsDoc.BACKUP_OPERATIONS_LATENCY.getDescription()).tags(new String[]{BackupManagerMetricsDoc.MetricKeyName.OPERATION.asString(), operationType.name()}).serviceLevelObjectives(BackupManagerMetricsDoc.BACKUP_OPERATIONS_LATENCY.getTimerSLOs()).register(this.registry);
    }

    private AtomicLong getOperationInProgress(BackupManagerMetricsDoc.OperationType operationType) {
        AtomicLong value = this.operationInProgress.get((Object)operationType);
        if (value == null) {
            value = new AtomicLong();
            this.operationInProgress.put(operationType, value);
            Gauge.builder((String)BackupManagerMetricsDoc.BACKUP_OPERATIONS_IN_PROGRESS.getName(), value::get).description(BackupManagerMetricsDoc.BACKUP_OPERATIONS_IN_PROGRESS.getDescription()).register(this.registry);
        }
        return value;
    }

    private OperationMetrics start(BackupManagerMetricsDoc.OperationType operation) {
        Timer timer = this.backupOperationLatency.computeIfAbsent(operation, this::registerBackupLatency);
        CloseableSilently timerSample = MicrometerUtil.timer((Timer)timer, (Timer.Sample)Timer.start((Clock)this.registry.config().clock()));
        this.getOperationInProgress(operation).incrementAndGet();
        return new OperationMetrics(timerSample, operation);
    }

    public final class OperationMetrics {
        final CloseableSilently timer;
        final BackupManagerMetricsDoc.OperationType operation;

        private OperationMetrics(CloseableSilently timer, BackupManagerMetricsDoc.OperationType operation) {
            this.timer = timer;
            this.operation = operation;
        }

        public <T> void complete(T ignored, Throwable throwable) {
            this.timer.close();
            BackupManagerMetrics.this.getOperationInProgress(this.operation).decrementAndGet();
            BackupManagerMetricsDoc.OperationResult result = throwable != null ? BackupManagerMetricsDoc.OperationResult.FAILED : BackupManagerMetricsDoc.OperationResult.COMPLETED;
            ((Counter)BackupManagerMetrics.this.totalOperations.computeIfAbsent((Object)this.operation, (Object)result, BackupManagerMetrics.this::registerTotalOperation)).increment();
        }
    }
}

