/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.stream.Stream;

public enum BackupManagerMetricsDoc implements ExtendedMeterDocumentation
{
    BACKUP_OPERATIONS_TOTAL{

        public String getDescription() {
            return "Total number of backup operations";
        }

        public String getName() {
            return "zeebe.backup.operations.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MetricKeyName.PARTITION, MetricKeyName.OPERATION, MetricKeyName.RESULT};
        }
    }
    ,
    BACKUP_OPERATIONS_IN_PROGRESS{

        public String getDescription() {
            return "Number of backup operations that are in progress";
        }

        public String getName() {
            return "zeebe.backup.operations.in.progress";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MetricKeyName.PARTITION, MetricKeyName.OPERATION};
        }
    }
    ,
    BACKUP_OPERATIONS_LATENCY{

        public String getDescription() {
            return "Latency of backup operations";
        }

        public String getName() {
            return "zeebe.backup.operations.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getBaseUnit() {
            return "seconds";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MetricKeyName.PARTITION, MetricKeyName.OPERATION};
        }

        public Duration[] getTimerSLOs() {
            return (Duration[])Stream.of(10, 100, 1000, 10000, 60000, 300000).map(s -> Duration.ofMillis(s.longValue())).toArray(Duration[]::new);
        }
    };


    public static enum MetricKeyName implements KeyName
    {
        PARTITION("partition"),
        OPERATION("operation"),
        RESULT("result");

        private final String key;

        private MetricKeyName(String key) {
            this.key = key;
        }

        public String asString() {
            return this.key;
        }
    }

    public static enum OperationResult {
        FAILED("failed"),
        COMPLETED("completed");

        private final String value;

        private OperationResult(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum OperationType {
        TAKE("take"),
        STATUS("status"),
        LIST("list"),
        DELETE("delete");

        private final String value;

        private OperationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

