/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.camunda.zeebe.backup.metrics.CheckpointMetricsDoc;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class CheckpointMetrics {
    private final MeterRegistry registry;
    private final Map<CheckpointMetricsDoc.CheckpointMetricsResultValue, Counter> checkpointRecords = new EnumMap<CheckpointMetricsDoc.CheckpointMetricsResultValue, Counter>(CheckpointMetricsDoc.CheckpointMetricsResultValue.class);
    private final AtomicLong checkpointPosition = new AtomicLong(0L);
    private final AtomicLong checkpointId = new AtomicLong(0L);

    public CheckpointMetrics(MeterRegistry meterRegistry) {
        this.registry = Objects.requireNonNull(meterRegistry, "registry cannot be null");
        Gauge.builder((String)CheckpointMetricsDoc.CHECKPOINT_POSITION.getName(), this.checkpointPosition::get).description(CheckpointMetricsDoc.CHECKPOINT_POSITION.getDescription()).register(meterRegistry);
        Gauge.builder((String)CheckpointMetricsDoc.CHECKPOINT_ID.getName(), this.checkpointId::get).description(CheckpointMetricsDoc.CHECKPOINT_ID.getDescription()).register(meterRegistry);
    }

    public void created(long checkpointId, long checkpointPosition) {
        this.setCheckpointId(checkpointId, checkpointPosition);
        this.checkpointRecords.computeIfAbsent(CheckpointMetricsDoc.CheckpointMetricsResultValue.CREATED, this::registerCheckpointRecords).increment();
    }

    public void setCheckpointId(long checkpointId, long checkpointPosition) {
        this.checkpointId.set(checkpointId);
        this.checkpointPosition.set(checkpointPosition);
    }

    public void ignored() {
        this.checkpointRecords.computeIfAbsent(CheckpointMetricsDoc.CheckpointMetricsResultValue.IGNORED, this::registerCheckpointRecords).increment();
    }

    private Counter registerCheckpointRecords(CheckpointMetricsDoc.CheckpointMetricsResultValue value) {
        return Counter.builder((String)CheckpointMetricsDoc.CHECKPOINTS_RECORDS.getName()).description(CheckpointMetricsDoc.CHECKPOINTS_RECORDS.getDescription()).tags(new String[]{CheckpointMetricsDoc.CheckpointMetricsKeyName.RESULT.asString(), value.value()}).register(this.registry);
    }
}

