/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum CheckpointMetricsDoc implements ExtendedMeterDocumentation
{
    CHECKPOINTS_RECORDS{

        public String getName() {
            return "zeebe.checkpoint.records.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of checkpoint records processed by stream processor. Processing can result in either creating a new checkpoint or ignoring the record. This can be observed by filtering for label 'result'.";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, CheckpointMetricsKeyName.RESULT};
        }
    }
    ,
    CHECKPOINT_POSITION{

        public String getName() {
            return "zeebe.checkpoint.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "Position of the last checkpoint ";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    CHECKPOINT_ID{

        public String getName() {
            return "zeebe.checkpoint.id";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "Id of the last checkpoint ";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    };


    public static enum CheckpointMetricsResultValue {
        CREATED("created"),
        IGNORED("ignored");

        private final String value;

        private CheckpointMetricsResultValue(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum CheckpointMetricsKeyName implements KeyName
    {
        RESULT{

            public String asString() {
                return "result";
            }
        };

    }
}

