/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CompensateEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.MessageEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.model.bpmn.builder.zeebe.MessageBuilder;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ConditionalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimeCycle;
import io.camunda.zeebe.model.bpmn.instance.TimeDate;
import io.camunda.zeebe.model.bpmn.instance.TimeDuration;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeInput;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeOutput;
import java.util.function.Consumer;

public abstract class AbstractCatchEventBuilder<B extends AbstractCatchEventBuilder<B, E>, E extends CatchEvent>
extends AbstractEventBuilder<B, E>
implements ZeebeVariablesMappingBuilder<B> {
    protected AbstractCatchEventBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public B parallelMultiple() {
        ((CatchEvent)this.element).isParallelMultiple();
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public B message(String messageName) {
        MessageEventDefinition messageEventDefinition = this.createMessageEventDefinition(messageName);
        ((CatchEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public B message(Consumer<MessageBuilder> messageBuilderConsumer) {
        MessageEventDefinition messageEventDefinition = this.createInstance(MessageEventDefinition.class);
        ((CatchEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        Message message = this.createMessage();
        MessageBuilder builder = new MessageBuilder(this.modelInstance, message);
        messageBuilderConsumer.accept(builder);
        messageEventDefinition.setMessage(message);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public MessageEventDefinitionBuilder messageEventDefinition() {
        MessageEventDefinition eventDefinition = this.createEmptyMessageEventDefinition();
        ((CatchEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new MessageEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    public B signal(String signalName) {
        SignalEventDefinition signalEventDefinition = this.createSignalEventDefinition(signalName);
        ((CatchEvent)this.element).getEventDefinitions().add(signalEventDefinition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public B timerWithDateExpression(String timerDate) {
        return this.timerWithDate(this.asZeebeExpression(timerDate));
    }

    public B timerWithDate(String timerDate) {
        TimeDate timeDate = this.createInstance(TimeDate.class);
        timeDate.setTextContent(timerDate);
        TimerEventDefinition timerEventDefinition = this.createInstance(TimerEventDefinition.class);
        timerEventDefinition.setTimeDate(timeDate);
        ((CatchEvent)this.element).getEventDefinitions().add(timerEventDefinition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public B timerWithDurationExpression(String timerDuration) {
        return this.timerWithDuration(this.asZeebeExpression(timerDuration));
    }

    public B timerWithDuration(String timerDuration) {
        TimeDuration timeDuration = this.createInstance(TimeDuration.class);
        timeDuration.setTextContent(timerDuration);
        TimerEventDefinition timerEventDefinition = this.createInstance(TimerEventDefinition.class);
        timerEventDefinition.setTimeDuration(timeDuration);
        ((CatchEvent)this.element).getEventDefinitions().add(timerEventDefinition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public B timerWithCycleExpression(String timerCycle) {
        return this.timerWithCycle(this.asZeebeExpression(timerCycle));
    }

    public B timerWithCycle(String timerCycle) {
        TimeCycle timeCycle = this.createInstance(TimeCycle.class);
        timeCycle.setTextContent(timerCycle);
        TimerEventDefinition timerEventDefinition = this.createInstance(TimerEventDefinition.class);
        timerEventDefinition.setTimeCycle(timeCycle);
        ((CatchEvent)this.element).getEventDefinitions().add(timerEventDefinition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition() {
        return this.compensateEventDefinition(null);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition(String id) {
        CompensateEventDefinition eventDefinition = this.createInstance(CompensateEventDefinition.class);
        if (id != null) {
            eventDefinition.setId(id);
        }
        ((CatchEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new CompensateEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    public ConditionalEventDefinitionBuilder conditionalEventDefinition() {
        return this.conditionalEventDefinition(null);
    }

    public ConditionalEventDefinitionBuilder conditionalEventDefinition(String id) {
        ConditionalEventDefinition eventDefinition = this.createInstance(ConditionalEventDefinition.class);
        if (id != null) {
            eventDefinition.setId(id);
        }
        ((CatchEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new ConditionalEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    @Override
    public B condition(String condition) {
        this.conditionalEventDefinition().condition(condition);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    @Override
    public B zeebeInputExpression(String sourceExpression, String target) {
        String expression = this.asZeebeExpression(sourceExpression);
        return (B)this.zeebeInput(expression, target);
    }

    @Override
    public B zeebeOutputExpression(String sourceExpression, String target) {
        String expression = this.asZeebeExpression(sourceExpression);
        return (B)this.zeebeOutput(expression, target);
    }

    @Override
    public B zeebeInput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeInput input = this.createChild(ioMapping, ZeebeInput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }

    @Override
    public B zeebeOutput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeOutput input = this.createChild(ioMapping, ZeebeOutput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractCatchEventBuilder)this.myself);
    }
}

