/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EventDefinitionValidator
implements ModelElementValidator<EventDefinition> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENT_DEFINITIONS = Arrays.asList(MessageEventDefinition.class, TimerEventDefinition.class, ErrorEventDefinition.class);

    public Class<EventDefinition> getElementType() {
        return EventDefinition.class;
    }

    public void validate(EventDefinition element, ValidationResultCollector validationResultCollector) {
        Class elementType = element.getElementType().getInstanceType();
        if (!SUPPORTED_EVENT_DEFINITIONS.contains(elementType)) {
            validationResultCollector.addError(0, "Event definition of this type is not supported");
        }
    }
}

