/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.builder.AbstractEmbeddedSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import java.util.function.Consumer;

public class EmbeddedSubProcessBuilder
extends AbstractEmbeddedSubProcessBuilder<EmbeddedSubProcessBuilder, AbstractSubProcessBuilder<?>> {
    protected EmbeddedSubProcessBuilder(AbstractSubProcessBuilder subProcessBuilder) {
        super(subProcessBuilder, EmbeddedSubProcessBuilder.class);
    }

    public StartEventBuilder startEvent() {
        return this.startEvent(null);
    }

    public StartEventBuilder startEvent(String id) {
        StartEvent start = this.subProcessBuilder.createChild(StartEvent.class, id);
        BpmnShape startShape = this.subProcessBuilder.createBpmnShape(start);
        BpmnShape subProcessShape = this.subProcessBuilder.findBpmnShape((BaseElement)this.subProcessBuilder.getElement());
        if (subProcessShape != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            Bounds startBounds = startShape.getBounds();
            double subProcessX = subProcessBounds.getX();
            double subProcessY = subProcessBounds.getY();
            double subProcessHeight = subProcessBounds.getHeight();
            double startHeight = startBounds.getHeight();
            startBounds.setX(subProcessX + 50.0);
            startBounds.setY(subProcessY + subProcessHeight / 2.0 - startHeight / 2.0);
        }
        return start.builder();
    }

    public EventSubProcessBuilder eventSubProcess() {
        return this.eventSubProcess(null);
    }

    public EventSubProcessBuilder eventSubProcess(String id) {
        SubProcess subProcess = this.subProcessBuilder.createChild(SubProcess.class, id);
        subProcess.setTriggeredByEvent(true);
        BpmnShape targetBpmnShape = this.subProcessBuilder.createBpmnShape(subProcess);
        this.setCoordinates(targetBpmnShape);
        this.subProcessBuilder.resizeBpmnShape(targetBpmnShape);
        EventSubProcessBuilder eventSubProcessBuilder = new EventSubProcessBuilder(this.subProcessBuilder.modelInstance, subProcess);
        return eventSubProcessBuilder;
    }

    public EmbeddedSubProcessBuilder eventSubProcess(String id, Consumer<EventSubProcessBuilder> consumer) {
        EventSubProcessBuilder builder = this.eventSubProcess(id);
        consumer.accept(builder);
        return this;
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id, Consumer<IntermediateCatchEventBuilder> catchEventBuilderConsumer) {
        IntermediateCatchEventBuilder catchEventBuilder = this.intermediateCatchEvent(id);
        catchEventBuilderConsumer.accept(catchEventBuilder);
        return catchEventBuilder;
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id) {
        IntermediateCatchEvent catchEvent = this.subProcessBuilder.createChild(IntermediateCatchEvent.class, id);
        BpmnShape bpmnShape = this.subProcessBuilder.createBpmnShape(catchEvent);
        this.subProcessBuilder.setCoordinates(bpmnShape);
        this.subProcessBuilder.resizeBpmnShape(bpmnShape);
        return catchEvent.builder();
    }

    protected void setCoordinates(BpmnShape targetBpmnShape) {
        SubProcess eventSubProcess = (SubProcess)targetBpmnShape.getBpmnElement();
        SubProcess parentSubProcess = (SubProcess)eventSubProcess.getParentElement();
        BpmnShape parentBpmnShape = this.subProcessBuilder.findBpmnShape(parentSubProcess);
        Bounds targetBounds = targetBpmnShape.getBounds();
        Bounds parentBounds = parentBpmnShape.getBounds();
        double ycoord = parentBounds.getHeight() + parentBounds.getY();
        double xcoord = parentBounds.getWidth() / 2.0 - targetBounds.getWidth() / 2.0 + parentBounds.getX();
        if (xcoord - parentBounds.getX() < 50.0) {
            xcoord = 50.0 + parentBounds.getX();
        }
        targetBounds.setY(ycoord);
        targetBounds.setX(xcoord);
    }
}

