/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class SignalValidator
implements ModelElementValidator<Signal> {
    public Class<Signal> getElementType() {
        return Signal.class;
    }

    public void validate(Signal element, ValidationResultCollector validationResultCollector) {
        if (this.isReferredByCatchEvent(element) || this.isReferredByThrowEvent(element) || this.isReferredByEndEvent(element) || this.isReferredByEventSubProcessStartEvent(element)) {
            this.validateName(element, validationResultCollector);
        }
        this.validateIfReferredByStartEvent(element, validationResultCollector);
    }

    private void validateIfReferredByStartEvent(Signal element, ValidationResultCollector validationResultCollector) {
        Collection startEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(StartEvent.class).stream()).collect(Collectors.toList());
        List<EventDefinition> referredStartEvents = startEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof SignalEventDefinition && ((SignalEventDefinition)e).getSignal() == element).collect(Collectors.toList());
        if (referredStartEvents.size() > 1) {
            this.validateList(referredStartEvents, validationResultCollector);
        } else if (referredStartEvents.size() == 1) {
            this.validateName(element, validationResultCollector);
        }
    }

    private boolean isReferredByCatchEvent(Signal element) {
        Collection<IntermediateCatchEvent> intermediateCatchEvents = this.getAllElementsByType(element, IntermediateCatchEvent.class);
        Collection<BoundaryEvent> boundaryEvents = this.getAllElementsByType(element, BoundaryEvent.class);
        return Stream.concat(intermediateCatchEvents.stream(), boundaryEvents.stream()).flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof SignalEventDefinition && ((SignalEventDefinition)e).getSignal() == element);
    }

    private boolean isReferredByThrowEvent(Signal element) {
        Collection<IntermediateThrowEvent> intermediateThrowEvents = this.getAllElementsByType(element, IntermediateThrowEvent.class);
        return intermediateThrowEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof SignalEventDefinition && ((SignalEventDefinition)e).getSignal() == element);
    }

    private boolean isReferredByEndEvent(Signal element) {
        Collection<EndEvent> endEvents = this.getAllElementsByType(element, EndEvent.class);
        return endEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof SignalEventDefinition && ((SignalEventDefinition)e).getSignal() == element);
    }

    private boolean isReferredByEventSubProcessStartEvent(Signal element) {
        Collection startEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(SubProcess.class).stream()).flatMap(p -> p.getChildElementsByType(StartEvent.class).stream()).collect(Collectors.toList());
        long numReferredSubProcessStartEvents = startEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof SignalEventDefinition && ((SignalEventDefinition)e).getSignal() == element).count();
        return numReferredSubProcessStartEvents == 1L;
    }

    private void validateName(Signal element, ValidationResultCollector validationResultCollector) {
        if (element.getName() == null || element.getName().isEmpty()) {
            validationResultCollector.addError(0, "Name must be present and not empty");
        }
    }

    private void validateList(List<EventDefinition> catchEvents, ValidationResultCollector validationResultCollector) {
        catchEvents.forEach(event -> {
            SignalEventDefinition e = (SignalEventDefinition)event;
            this.validateName(e.getSignal(), validationResultCollector);
        });
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByType(Signal element, Class<T> type) {
        return element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> this.getAllElementsByTypeRecursive((ModelElementInstance)p, type).stream()).collect(Collectors.toList());
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByTypeRecursive(ModelElementInstance element, Class<T> type) {
        Collection result = element.getChildElementsByType(type);
        List childDomElements = element.getDomElement().getChildElements();
        Collection childModelElements = ModelUtil.getModelElementCollection((Collection)childDomElements, (ModelInstanceImpl)((ModelInstanceImpl)element.getModelInstance()));
        result.addAll(childModelElements.stream().flatMap(child -> this.getAllElementsByTypeRecursive((ModelElementInstance)child, type).stream()).collect(Collectors.toList()));
        return result;
    }
}

