/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebePriorityDefinition;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ZeebePriorityDefinitionValidator
implements ModelElementValidator<ZeebePriorityDefinition> {
    public static final Integer PRIORITY_LOWER_BOUND = 0;
    public static final Integer PRIORITY_UPPER_BOUND = 100;

    public Class<ZeebePriorityDefinition> getElementType() {
        return ZeebePriorityDefinition.class;
    }

    public void validate(ZeebePriorityDefinition zeebePriorityDefinition, ValidationResultCollector validationResultCollector) {
        String priority = zeebePriorityDefinition.getPriority();
        try {
            int priorityValue = Integer.parseInt(priority);
            if (priorityValue < PRIORITY_LOWER_BOUND || priorityValue > PRIORITY_UPPER_BOUND) {
                validationResultCollector.addError(0, String.format("Priority must be a number between 0 and 100, but was '%s'.", priority));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

