/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.impl.QueryImpl;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import java.util.Optional;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class IntermediateThrowEventValidator
implements ModelElementValidator<IntermediateThrowEvent> {
    public Class<IntermediateThrowEvent> getElementType() {
        return IntermediateThrowEvent.class;
    }

    public void validate(IntermediateThrowEvent element, ValidationResultCollector validationResultCollector) {
        CompensateEventDefinition definition;
        String waitForCompletion;
        Optional<CompensateEventDefinition> compensateEventDefinitionOpt = this.getEventDefinition(element);
        if (compensateEventDefinitionOpt.isPresent() && (waitForCompletion = (definition = compensateEventDefinitionOpt.get()).getAttributeValue("waitForCompletion")) != null && !Boolean.parseBoolean(waitForCompletion)) {
            validationResultCollector.addError(0, "A compensation intermediate throwing event waitForCompletion attribute must be true or not present");
        }
    }

    private Optional<CompensateEventDefinition> getEventDefinition(IntermediateThrowEvent event) {
        return new QueryImpl<EventDefinition>(event.getEventDefinitions()).filterByType(CompensateEventDefinition.class).findSingleResult();
    }
}

