/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.builder.AbstractBaseElementBuilder;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListenerEventType;

public class TaskListenerBuilder {
    private final ZeebeTaskListener element;
    private final AbstractBaseElementBuilder<?, ?> elementBuilder;

    protected TaskListenerBuilder(ZeebeTaskListener element, AbstractBaseElementBuilder<?, ?> elementBuilder) {
        this.element = element;
        this.elementBuilder = elementBuilder;
    }

    public TaskListenerBuilder eventType(ZeebeTaskListenerEventType eventType) {
        this.element.setEventType(eventType);
        return this;
    }

    public TaskListenerBuilder create() {
        return this.eventType(ZeebeTaskListenerEventType.create);
    }

    public TaskListenerBuilder update() {
        return this.eventType(ZeebeTaskListenerEventType.update);
    }

    public TaskListenerBuilder assignment() {
        return this.eventType(ZeebeTaskListenerEventType.assignment);
    }

    public TaskListenerBuilder complete() {
        return this.eventType(ZeebeTaskListenerEventType.complete);
    }

    public TaskListenerBuilder cancel() {
        return this.eventType(ZeebeTaskListenerEventType.cancel);
    }

    public TaskListenerBuilder type(String type) {
        this.element.setType(type);
        return this;
    }

    public TaskListenerBuilder typeExpression(String typeExpression) {
        return this.type(this.elementBuilder.asZeebeExpression(typeExpression));
    }

    public TaskListenerBuilder retries(String retries) {
        this.element.setRetries(retries);
        return this;
    }

    public TaskListenerBuilder retriesExpression(String retriesExpression) {
        return this.retries(this.elementBuilder.asZeebeExpression(retriesExpression));
    }
}

