/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.AdHocSubProcess;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class AdHocSubProcessValidator
implements ModelElementValidator<AdHocSubProcess> {
    public Class<AdHocSubProcess> getElementType() {
        return AdHocSubProcess.class;
    }

    public void validate(AdHocSubProcess adHocSubProcess, ValidationResultCollector validationResultCollector) {
        Collection<FlowElement> flowElements = adHocSubProcess.getFlowElements();
        if (flowElements.isEmpty()) {
            validationResultCollector.addError(0, "Must have at least one activity.");
        }
        if (AdHocSubProcessValidator.hasStartEvent(flowElements)) {
            validationResultCollector.addError(0, "Must not contain a start event.");
        }
        if (AdHocSubProcessValidator.hasEndEvent(flowElements)) {
            validationResultCollector.addError(0, "Must not contain an end event.");
        }
    }

    private static boolean hasStartEvent(Collection<FlowElement> flowElements) {
        return flowElements.stream().anyMatch(StartEvent.class::isInstance);
    }

    private static boolean hasEndEvent(Collection<FlowElement> flowElements) {
        return flowElements.stream().anyMatch(EndEvent.class::isInstance);
    }
}

