/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.instance.AdHocSubProcess;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAdHoc;

public class AbstractAdHocSubProcessBuilder<B extends AbstractAdHocSubProcessBuilder<B>>
extends AbstractSubProcessBuilder<B> {
    protected boolean isDone = false;

    protected AbstractAdHocSubProcessBuilder(BpmnModelInstance modelInstance, AdHocSubProcess element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public B zeebeActiveElementsCollectionExpression(String expression) {
        ZeebeAdHoc adHoc = this.getCreateSingleExtensionElement(ZeebeAdHoc.class);
        adHoc.setActiveElementsCollection(this.asZeebeExpression(expression));
        return (B)((AbstractAdHocSubProcessBuilder)this.myself);
    }

    @Override
    protected <T extends FlowNode> T createTarget(Class<T> typeClass, String identifier) {
        if (this.isDone) {
            return super.createTarget(typeClass, identifier);
        }
        return this.createChildInsideAdHocSubProcess(typeClass, identifier);
    }

    protected <T extends FlowNode> T createChildInsideAdHocSubProcess(Class<T> typeClass, String identifier) {
        double maxBoundY = this.getMaxBoundY();
        FlowNode child = (FlowNode)this.createChild(typeClass, identifier);
        BpmnShape childShape = this.createBpmnShape(child);
        this.setCoordinates(childShape, maxBoundY);
        this.resizeBpmnShape(childShape);
        return (T)child;
    }

    protected void setCoordinates(BpmnShape childShape, double maxBoundY) {
        BpmnShape subProcessShape = this.findBpmnShape((BaseElement)this.element);
        if (subProcessShape != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            Bounds childBounds = childShape.getBounds();
            double subProcessX = subProcessBounds.getX();
            childBounds.setX(subProcessX + 50.0);
            double subProcessY = subProcessBounds.getY();
            double childMinY = subProcessY + 50.0;
            double childY = Math.max(childMinY, maxBoundY + 50.0);
            childBounds.setY(childY);
        }
    }

    protected double getMaxBoundY() {
        double maxY = 0.0;
        for (FlowElement flowElement : ((SubProcess)this.element).getFlowElements()) {
            BpmnShape bpmnShape = this.findBpmnShape(flowElement);
            if (bpmnShape == null) continue;
            Bounds bounds = bpmnShape.getBounds();
            maxY = Math.max(bounds.getY() + bounds.getHeight(), maxY);
        }
        return maxY;
    }

    B adHocSubProcessDone() {
        this.isDone = true;
        return (B)((AbstractAdHocSubProcessBuilder)this.myself);
    }
}

