/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Association;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class BoundaryEventValidator
implements ModelElementValidator<BoundaryEvent> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENT_DEFINITIONS = Arrays.asList(TimerEventDefinition.class, MessageEventDefinition.class, ErrorEventDefinition.class, SignalEventDefinition.class, EscalationEventDefinition.class, CompensateEventDefinition.class);

    public Class<BoundaryEvent> getElementType() {
        return BoundaryEvent.class;
    }

    public void validate(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        if (element.getAttachedTo() == null) {
            validationResultCollector.addError(0, "Must be attached to an activity");
        }
        if (!element.getIncoming().isEmpty()) {
            validationResultCollector.addError(0, "Cannot have incoming sequence flows");
        }
        if (element.getOutgoing().isEmpty() && !this.isValidCompensationBoundaryEvent(element)) {
            validationResultCollector.addError(0, "Must have at least one outgoing sequence flow or association");
        }
        this.validateEventDefinition(element, validationResultCollector);
        ModelUtil.validateExecutionListenersDefinitionForElement(element, validationResultCollector, listeners -> {
            Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
            eventDefinitions.stream().findFirst().ifPresent(eventDefinition -> {
                if (eventDefinition instanceof CompensateEventDefinition) {
                    validationResultCollector.addError(0, "Execution listeners of type 'start' and 'end' are not supported by [compensation] boundary events");
                } else {
                    boolean startExecutionListenersDefined = listeners.stream().map(ZeebeExecutionListener::getEventType).anyMatch(ZeebeExecutionListenerEventType.start::equals);
                    if (startExecutionListenersDefined) {
                        validationResultCollector.addError(0, "Execution listeners of type 'start' are not supported by boundary events");
                    }
                }
            });
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidCompensationBoundaryEvent(BoundaryEvent element) {
        Optional<Association> association = element.getModelInstance().getModelElementsByType(Association.class).stream().filter(a -> a.getSource().getId().equals(element.getId())).findFirst();
        if (!element.getOutgoing().isEmpty()) return false;
        if (!association.isPresent()) return false;
        if (!element.getEventDefinitions().stream().anyMatch(CompensateEventDefinition.class::isInstance)) return false;
        return true;
    }

    private void validateEventDefinition(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            validationResultCollector.addError(0, "Must have exactly one event definition");
        }
        eventDefinitions.forEach(def -> {
            if (SUPPORTED_EVENT_DEFINITIONS.stream().noneMatch(type -> type.isInstance(def))) {
                validationResultCollector.addError(0, "Boundary events must be one of: timer, message, error, signal, escalation");
            }
        });
        ModelUtil.verifyEventDefinition(element, error -> validationResultCollector.addError(0, error));
    }
}

