/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListenerEventType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class TaskListenerValidator
implements ModelElementValidator<ZeebeTaskListener> {
    private static final List<ZeebeTaskListenerEventType> SUPPORTED_VALUES = Arrays.asList(ZeebeTaskListenerEventType.assigning, ZeebeTaskListenerEventType.updating, ZeebeTaskListenerEventType.completing);
    private static final List<ZeebeTaskListenerEventType> SUPPORTED_DEPRECATED_VALUES = Arrays.asList(ZeebeTaskListenerEventType.assignment, ZeebeTaskListenerEventType.update, ZeebeTaskListenerEventType.complete);

    public Class<ZeebeTaskListener> getElementType() {
        return ZeebeTaskListener.class;
    }

    public void validate(ZeebeTaskListener zeebeTaskListener, ValidationResultCollector validationResultCollector) {
        ZeebeTaskListenerEventType eventType = zeebeTaskListener.getEventType();
        if (eventType != null && !SUPPORTED_VALUES.contains((Object)eventType) && !SUPPORTED_DEPRECATED_VALUES.contains((Object)eventType)) {
            String errorMessage = String.format("Task listener event type '%s' is not supported. Currently, only %s event types and %s deprecated event types are supported.", new Object[]{eventType, SUPPORTED_VALUES.stream().map(Enum::name).collect(Collectors.joining("', '", "'", "'")), SUPPORTED_DEPRECATED_VALUES.stream().map(Enum::name).collect(Collectors.joining("', '", "'", "'"))});
            validationResultCollector.addError(0, errorMessage);
        }
    }
}

