/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import io.camunda.zeebe.model.bpmn.validation.zeebe.IdentifiableBpmnElementValidator;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class StartEventValidator
implements ModelElementValidator<StartEvent> {
    public Class<StartEvent> getElementType() {
        return StartEvent.class;
    }

    public void validate(StartEvent element, ValidationResultCollector validationResultCollector) {
        IdentifiableBpmnElementValidator.validate(element, validationResultCollector);
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() > 1) {
            validationResultCollector.addError(0, "Start event can't have more than one type");
        }
        ModelUtil.validateExecutionListenersDefinitionForElement(element, validationResultCollector, listeners -> {
            boolean startExecutionListenersDefined = listeners.stream().map(ZeebeExecutionListener::getEventType).anyMatch(ZeebeExecutionListenerEventType.start::equals);
            if (startExecutionListenersDefined) {
                validationResultCollector.addError(0, "Execution listeners of type 'start' are not supported by start events");
            }
        });
    }
}

