/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExecutionListenerBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebePropertiesBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebePropertiesBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariableMappingBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, E>, E extends Activity>
extends AbstractFlowNodeBuilder<B, E>
implements ZeebeVariablesMappingBuilder<B>,
ZeebeExecutionListenersBuilder<B>,
ZeebePropertiesBuilder<B> {
    private final ZeebeVariablesMappingBuilder<B> variablesMappingBuilder;
    private final ZeebeExecutionListenersBuilder<B> zeebeExecutionListenersBuilder;
    private final ZeebePropertiesBuilder<B> zeebePropertiesBuilder;

    protected AbstractActivityBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
        this.variablesMappingBuilder = new ZeebeVariableMappingBuilderImpl<AbstractActivityBuilder>((AbstractActivityBuilder)this.myself);
        this.zeebeExecutionListenersBuilder = new ZeebeExecutionListenersBuilderImpl<AbstractActivityBuilder>((AbstractActivityBuilder)this.myself);
        this.zeebePropertiesBuilder = new ZeebePropertiesBuilderImpl<AbstractActivityBuilder>((AbstractActivityBuilder)this.myself);
    }

    public BoundaryEventBuilder boundaryEvent() {
        return this.boundaryEvent(null);
    }

    public BoundaryEventBuilder boundaryEvent(String id) {
        BoundaryEvent boundaryEvent = this.createSibling(BoundaryEvent.class, id);
        boundaryEvent.setAttachedTo((Activity)this.element);
        BpmnShape boundaryEventBpmnShape = this.createBpmnShape(boundaryEvent);
        this.setBoundaryEventCoordinates(boundaryEventBpmnShape);
        return boundaryEvent.builder();
    }

    public BoundaryEventBuilder boundaryEvent(String id, Consumer<BoundaryEventBuilder> consumer) {
        BoundaryEventBuilder builder = this.boundaryEvent(id);
        consumer.accept(builder);
        return builder;
    }

    public MultiInstanceLoopCharacteristicsBuilder multiInstance() {
        MultiInstanceLoopCharacteristics miCharacteristics = this.createChild(MultiInstanceLoopCharacteristics.class);
        return miCharacteristics.builder();
    }

    public B multiInstance(Consumer<MultiInstanceLoopCharacteristicsBuilder> consumer) {
        MultiInstanceLoopCharacteristicsBuilder builder = this.multiInstance();
        consumer.accept(builder);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    protected double calculateXCoordinate(Bounds boundaryEventBounds) {
        BpmnShape attachedToElement = this.findBpmnShape((BaseElement)this.element);
        double x = 0.0;
        if (attachedToElement != null) {
            Bounds attachedToBounds = attachedToElement.getBounds();
            Collection boundaryEvents = ((Activity)this.element).getParentElement().getChildElementsByType(BoundaryEvent.class);
            ArrayList<BoundaryEvent> attachedBoundaryEvents = new ArrayList<BoundaryEvent>();
            for (BoundaryEvent tmp : boundaryEvents) {
                if (!tmp.getAttachedTo().equals(this.element)) continue;
                attachedBoundaryEvents.add(tmp);
            }
            double attachedToX = attachedToBounds.getX();
            double attachedToWidth = attachedToBounds.getWidth();
            double boundaryWidth = boundaryEventBounds.getWidth();
            switch (attachedBoundaryEvents.size()) {
                case 2: {
                    x = attachedToX + attachedToWidth / 2.0 + boundaryWidth / 2.0;
                    break;
                }
                case 3: {
                    x = attachedToX + attachedToWidth / 2.0 - 1.5 * boundaryWidth;
                    break;
                }
                default: {
                    x = attachedToX + attachedToWidth / 2.0 - boundaryWidth / 2.0;
                }
            }
        }
        return x;
    }

    protected void setBoundaryEventCoordinates(BpmnShape bpmnShape) {
        BpmnShape activity = this.findBpmnShape((BaseElement)this.element);
        Bounds boundaryBounds = bpmnShape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (activity != null) {
            Bounds activityBounds = activity.getBounds();
            double activityY = activityBounds.getY();
            double activityHeight = activityBounds.getHeight();
            double boundaryHeight = boundaryBounds.getHeight();
            x = this.calculateXCoordinate(boundaryBounds);
            y = activityY + activityHeight - boundaryHeight / 2.0;
        }
        boundaryBounds.setX(x);
        boundaryBounds.setY(y);
    }

    @Override
    public B zeebeInputExpression(String sourceExpression, String target) {
        return (B)((AbstractActivityBuilder)this.variablesMappingBuilder.zeebeInputExpression(sourceExpression, target));
    }

    @Override
    public B zeebeOutputExpression(String sourceExpression, String target) {
        return (B)((AbstractActivityBuilder)this.variablesMappingBuilder.zeebeOutputExpression(sourceExpression, target));
    }

    @Override
    public B zeebeInput(String source, String target) {
        return (B)((AbstractActivityBuilder)this.variablesMappingBuilder.zeebeInput(source, target));
    }

    @Override
    public B zeebeOutput(String source, String target) {
        return (B)((AbstractActivityBuilder)this.variablesMappingBuilder.zeebeOutput(source, target));
    }

    @Override
    public B zeebeStartExecutionListener(String type, String retries) {
        return (B)((AbstractActivityBuilder)this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type, retries));
    }

    @Override
    public B zeebeStartExecutionListener(String type) {
        return (B)((AbstractActivityBuilder)this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type));
    }

    @Override
    public B zeebeEndExecutionListener(String type, String retries) {
        return (B)((AbstractActivityBuilder)this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type, retries));
    }

    @Override
    public B zeebeEndExecutionListener(String type) {
        return (B)((AbstractActivityBuilder)this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type));
    }

    @Override
    public B zeebeExecutionListener(Consumer<ExecutionListenerBuilder> executionListenerBuilderConsumer) {
        return (B)((AbstractActivityBuilder)this.zeebeExecutionListenersBuilder.zeebeExecutionListener(executionListenerBuilderConsumer));
    }

    @Override
    public B zeebeProperty(String name, String value) {
        return (B)((AbstractActivityBuilder)this.zeebePropertiesBuilder.zeebeProperty(name, value));
    }
}

