/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.AdHocSubProcess;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAdHoc;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.model.bpmn.validation.zeebe.IdentifiableBpmnElementValidator;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class AdHocSubProcessValidator
implements ModelElementValidator<AdHocSubProcess> {
    public Class<AdHocSubProcess> getElementType() {
        return AdHocSubProcess.class;
    }

    public void validate(AdHocSubProcess adHocSubProcess, ValidationResultCollector validationResultCollector) {
        IdentifiableBpmnElementValidator.validate(adHocSubProcess, validationResultCollector);
        AdHocSubProcessValidator.validateTaskDefinition(adHocSubProcess, validationResultCollector);
        AdHocSubProcessValidator.validationOutputCollectionAndOutputElement(adHocSubProcess, validationResultCollector);
        Collection<FlowElement> flowElements = adHocSubProcess.getFlowElements();
        if (flowElements.isEmpty()) {
            validationResultCollector.addError(0, "Must have at least one activity.");
        }
        if (AdHocSubProcessValidator.hasStartEvent(flowElements)) {
            validationResultCollector.addError(0, "Must not contain a start event.");
        }
        if (AdHocSubProcessValidator.hasEndEvent(flowElements)) {
            validationResultCollector.addError(0, "Must not contain an end event.");
        }
    }

    private static void validateTaskDefinition(AdHocSubProcess adHocSubProcess, ValidationResultCollector validationResultCollector) {
        ExtensionElements extensionElements = adHocSubProcess.getExtensionElements();
        if (extensionElements == null) {
            return;
        }
        ZeebeTaskDefinition taskDefinition = extensionElements.getChildElementsByType(ZeebeTaskDefinition.class).stream().findFirst().orElse(null);
        if (taskDefinition == null) {
            return;
        }
        if (!adHocSubProcess.isCancelRemainingInstances()) {
            validationResultCollector.addError(0, "Must not define cancelRemainingInstances in combination with zeebe:taskDefinition.");
        }
        if (adHocSubProcess.getCompletionCondition() != null) {
            validationResultCollector.addError(0, "Must not define completionCondition in combination with zeebe:taskDefinition.");
        }
        extensionElements.getChildElementsByType(ZeebeAdHoc.class).stream().findFirst().ifPresent(adHoc -> {
            if (adHoc.getActiveElementsCollection() != null && !adHoc.getActiveElementsCollection().isEmpty()) {
                validationResultCollector.addError(0, "Must not define activeElementsCollection in combination with zeebe:taskDefinition.");
            }
        });
    }

    private static void validationOutputCollectionAndOutputElement(AdHocSubProcess adHocSubProcess, ValidationResultCollector validationResultCollector) {
        ExtensionElements extensionElements = adHocSubProcess.getExtensionElements();
        if (extensionElements == null) {
            return;
        }
        extensionElements.getChildElementsByType(ZeebeAdHoc.class).forEach(adhoc -> {
            boolean outputCollectionEmpty;
            boolean outputElementEmpty = AdHocSubProcessValidator.nullOrEmpty(adhoc.getOutputElement());
            if (outputElementEmpty != (outputCollectionEmpty = AdHocSubProcessValidator.nullOrEmpty(adhoc.getOutputCollection()))) {
                validationResultCollector.addError(0, String.format("OutputElement and OutputCollection must both be set, or neither of them set. outputElement:%s and outputCollection:%s.", adhoc.getOutputElement(), adhoc.getOutputCollection()));
            }
        });
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static boolean hasStartEvent(Collection<FlowElement> flowElements) {
        return flowElements.stream().anyMatch(StartEvent.class::isInstance);
    }

    private static boolean hasEndEvent(Collection<FlowElement> flowElements) {
        return flowElements.stream().anyMatch(EndEvent.class::isInstance);
    }
}

