/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.Gateway;
import io.camunda.zeebe.model.bpmn.instance.InclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import io.camunda.zeebe.model.bpmn.validation.zeebe.IdentifiableBpmnElementValidator;
import java.util.Optional;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class SequenceFlowValidator
implements ModelElementValidator<SequenceFlow> {
    public Class<SequenceFlow> getElementType() {
        return SequenceFlow.class;
    }

    public void validate(SequenceFlow element, ValidationResultCollector validationResultCollector) {
        Gateway gateway;
        IdentifiableBpmnElementValidator.validate(element, validationResultCollector);
        if (element.getSource() instanceof ExclusiveGateway && (gateway = (ExclusiveGateway)element.getSource()).getOutgoing().size() > 1 && gateway.getDefault() != element && element.getConditionExpression() == null) {
            validationResultCollector.addError(0, "Must have a condition or be default flow");
        }
        if (element.getSource() instanceof InclusiveGateway && (gateway = (InclusiveGateway)element.getSource()).getOutgoing().size() > 1) {
            Optional<SequenceFlow> sequenceFlow = gateway.getOutgoing().stream().filter(x -> x.getConditionExpression() == null && x == element).findFirst();
            sequenceFlow.ifPresent(arg_0 -> SequenceFlowValidator.lambda$validate$1((InclusiveGateway)gateway, element, validationResultCollector, arg_0));
        }
    }

    private static /* synthetic */ void lambda$validate$1(InclusiveGateway gateway, SequenceFlow element, ValidationResultCollector validationResultCollector, SequenceFlow out) {
        if (gateway.getDefault() != element) {
            validationResultCollector.addError(0, "Must have a condition");
        }
    }
}

