/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.api;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum BrokerClientMetricsDoc implements ExtendedMeterDocumentation
{
    REQUEST_LATENCY{

        public String getDescription() {
            return "Latency of round-trip from gateway to broker";
        }

        public String getName() {
            return "zeebe.gateway.request.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{RequestKeyNames.REQUEST_TYPE};
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    FAILED_REQUESTS{

        public String getDescription() {
            return "Number of failed requests";
        }

        public String getName() {
            return "zeebe.gateway.failed.requests";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return RequestKeyNames.values();
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    TOTAL_REQUESTS{

        public String getDescription() {
            return "Number of requests";
        }

        public String getName() {
            return "zeebe.gateway.total.requests";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{RequestKeyNames.REQUEST_TYPE};
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    PARTITION_ROLE{

        public String getDescription() {
            return "The partition role of the broker. 0 = Follower, 3 = Leader.";
        }

        public String getName() {
            return "zeebe.gateway.topology.partition.roles";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return TopologyKeyNames.values();
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    };


    public static enum PartitionRoleValues {
        LEADER(3),
        FOLLOWER(0);

        private final int value;

        private PartitionRoleValues(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum TopologyKeyNames implements KeyName
    {
        BROKER{

            public String asString() {
                return "broker";
            }
        };

    }

    public static enum RequestKeyNames implements KeyName
    {
        REQUEST_TYPE{

            public String asString() {
                return "requestType";
            }
        }
        ,
        ERROR{

            public String asString() {
                return "error";
            }
        };

    }

    public static enum AdditionalErrorCodes {
        PARTITION_NOT_FOUND,
        NO_TOPOLOGY,
        TIMEOUT,
        UNKNOWN;

    }
}

