/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.impl;

import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.Subscription;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerClientRequestMetrics;
import io.camunda.zeebe.broker.client.api.BrokerResponseConsumer;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.broker.client.impl.BrokerRequestManager;
import io.camunda.zeebe.broker.client.impl.RoundRobinDispatchStrategy;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerClientImpl
implements BrokerClient {
    public static final Logger LOG = LoggerFactory.getLogger(BrokerClientImpl.class);
    private final BrokerTopologyManager topologyManager;
    private final BrokerRequestManager requestManager;
    private boolean isClosed;
    private Subscription jobAvailableSubscription;
    private final ClusterEventService eventService;
    private final ActorSchedulingService schedulingService;
    private final AtomixClientTransportAdapter atomixTransportAdapter;

    public BrokerClientImpl(Duration requestTimeout, MessagingService messagingService, ClusterEventService eventService, ActorSchedulingService schedulingService, BrokerTopologyManager topologyManager, BrokerClientRequestMetrics metrics) {
        this.eventService = eventService;
        this.schedulingService = schedulingService;
        this.topologyManager = topologyManager;
        this.atomixTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        this.requestManager = new BrokerRequestManager((ClientTransport)this.atomixTransportAdapter, topologyManager, new RoundRobinDispatchStrategy(), requestTimeout, metrics);
    }

    @Override
    public Collection<ActorFuture<Void>> start() {
        ActorFuture transportStarted = this.schedulingService.submitActor((Actor)this.atomixTransportAdapter);
        ActorFuture requestManagerStarted = this.schedulingService.submitActor((Actor)this.requestManager);
        return List.of(transportStarted, requestManagerStarted);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Closing gateway broker client ...");
        this.doAndLogException(() -> ((BrokerRequestManager)this.requestManager).close());
        LOG.debug("request manager closed");
        this.doAndLogException(() -> ((AtomixClientTransportAdapter)this.atomixTransportAdapter).close());
        LOG.debug("transport client closed");
        if (this.jobAvailableSubscription != null) {
            this.jobAvailableSubscription.close();
        }
        LOG.debug("Gateway broker client closed.");
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.requestManager.sendRequest(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequest(request, requestTimeout);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request) {
        return this.requestManager.sendRequestWithRetry(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequestWithRetry(request, requestTimeout);
    }

    @Override
    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.requestManager.sendRequestWithRetry(request).whenComplete((response, error) -> {
            if (error == null) {
                responseConsumer.accept(response.getKey(), response.getResponse());
            } else {
                throwableConsumer.accept((Throwable)error);
            }
        });
    }

    @Override
    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    @Override
    public void subscribeJobAvailableNotification(String topic, Consumer<String> handler) {
        this.jobAvailableSubscription = (Subscription)this.eventService.subscribe(topic, msg -> {
            handler.accept((String)msg);
            return CompletableFuture.completedFuture(null);
        }).join();
    }

    private void doAndLogException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error("Exception when closing client. Ignoring", (Throwable)e);
        }
    }
}

