/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.impl;

import io.camunda.zeebe.broker.client.api.BrokerClientMetricsDoc;
import io.camunda.zeebe.broker.client.api.BrokerClientRequestMetrics;
import io.camunda.zeebe.util.collection.Map3D;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class BrokerClientMetricsImpl
implements BrokerClientRequestMetrics {
    private final MeterRegistry registry;
    private final Table<Integer, String, Timer> requestLatency;
    private final Table<Integer, String, Counter> totalRequests;
    private final Map3D<Integer, String, Enum<?>, Counter> failedRequests;

    public BrokerClientMetricsImpl(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "must specify a meter registry");
        this.requestLatency = Table.simple();
        this.totalRequests = Table.simple();
        this.failedRequests = Map3D.simple();
    }

    @Override
    public void registerSuccessfulRequest(int partitionId, String requestType, long latencyMs) {
        ((Timer)this.requestLatency.computeIfAbsent((Object)partitionId, (Object)requestType, this::registerRequestLatencyCounter)).record(latencyMs, TimeUnit.MILLISECONDS);
        ((Counter)this.totalRequests.computeIfAbsent((Object)partitionId, (Object)requestType, this::registerTotalRequestCounter)).increment();
    }

    @Override
    public void registerFailedRequest(int partitionId, String requestType, Enum<?> error) {
        ((Counter)this.failedRequests.computeIfAbsent((Object)partitionId, (Object)requestType, error, this::registerFailedRequestCounter)).increment();
        ((Counter)this.totalRequests.computeIfAbsent((Object)partitionId, (Object)requestType, this::registerTotalRequestCounter)).increment();
    }

    private Counter registerFailedRequestCounter(int partitionId, String requestType, Enum<?> error) {
        return Counter.builder((String)BrokerClientMetricsDoc.FAILED_REQUESTS.getName()).description(BrokerClientMetricsDoc.FAILED_REQUESTS.getDescription()).tag(BrokerClientMetricsDoc.RequestKeyNames.REQUEST_TYPE.asString(), requestType).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), String.valueOf(partitionId)).tag(BrokerClientMetricsDoc.RequestKeyNames.ERROR.asString(), error.name()).register(this.registry);
    }

    private Counter registerTotalRequestCounter(int partitionId, String requestType) {
        return Counter.builder((String)BrokerClientMetricsDoc.TOTAL_REQUESTS.getName()).description(BrokerClientMetricsDoc.TOTAL_REQUESTS.getDescription()).tag(BrokerClientMetricsDoc.RequestKeyNames.REQUEST_TYPE.asString(), requestType).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), String.valueOf(partitionId)).register(this.registry);
    }

    private Timer registerRequestLatencyCounter(int partitionId, String requestType) {
        return Timer.builder((String)BrokerClientMetricsDoc.REQUEST_LATENCY.getName()).description(BrokerClientMetricsDoc.REQUEST_LATENCY.getDescription()).serviceLevelObjectives(BrokerClientMetricsDoc.REQUEST_LATENCY.getTimerSLOs()).tag(BrokerClientMetricsDoc.RequestKeyNames.REQUEST_TYPE.asString(), requestType).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), String.valueOf(partitionId)).register(this.registry);
    }
}

