/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.impl;

import io.camunda.zeebe.broker.client.api.BrokerClientMetricsDoc;
import io.camunda.zeebe.broker.client.api.BrokerClientTopologyMetrics;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class BrokerClientTopologyMetricsImpl
implements BrokerClientTopologyMetrics {
    private final MeterRegistry registry;
    private final Table<Integer, Integer, AtomicInteger> brokerTopologyRole;

    public BrokerClientTopologyMetricsImpl(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "must specify a meter registry");
        this.brokerTopologyRole = Table.simple();
    }

    @Override
    public void setRoleForPartition(int partitionId, int brokerId, BrokerClientMetricsDoc.PartitionRoleValues roleValue) {
        ((AtomicInteger)this.brokerTopologyRole.computeIfAbsent((Object)partitionId, (Object)brokerId, this::registerBrokerTopologyRole)).set(roleValue.value());
    }

    private AtomicInteger registerBrokerTopologyRole(int partitionId, int brokerId) {
        AtomicInteger role = new AtomicInteger();
        Gauge.builder((String)BrokerClientMetricsDoc.PARTITION_ROLE.getName(), (Object)role, Number::intValue).description(BrokerClientMetricsDoc.PARTITION_ROLE.getDescription()).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), String.valueOf(partitionId)).tag(BrokerClientMetricsDoc.TopologyKeyNames.BROKER.asString(), String.valueOf(brokerId)).register(this.registry);
        return role;
    }
}

