/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.impl;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import java.util.concurrent.atomic.AtomicInteger;

public final class RoundRobinDispatchStrategy
implements RequestDispatchStrategy {
    private final AtomicInteger partitions = new AtomicInteger(0);

    @Override
    public int determinePartition(BrokerTopologyManager topologyManager) {
        BrokerClusterState topology = topologyManager.getTopology();
        if (topology != null) {
            for (int i = 0; i < topology.getPartitionsCount(); ++i) {
                int offset = this.partitions.getAndIncrement();
                int partition = topology.getPartition(offset);
                if (topology.getLeaderForPartition(partition) == -2) continue;
                return partition;
            }
        }
        return -3;
    }
}

