/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import io.camunda.zeebe.util.startup.StartupStep;
import java.util.function.BiConsumer;

abstract class AbstractBrokerStartupStep
implements StartupStep<BrokerStartupContext> {
    AbstractBrokerStartupStep() {
    }

    public final ActorFuture<BrokerStartupContext> startup(BrokerStartupContext brokerStartupContext) {
        return this.createFutureAndRun(brokerStartupContext, (concurrencyControl, future) -> this.startupInternal(brokerStartupContext, (ConcurrencyControl)concurrencyControl, (ActorFuture<BrokerStartupContext>)future));
    }

    public final ActorFuture<BrokerStartupContext> shutdown(BrokerStartupContext brokerShutdownContext) {
        return this.createFutureAndRun(brokerShutdownContext, (concurrencyControl, future) -> this.shutdownInternal(brokerShutdownContext, (ConcurrencyControl)concurrencyControl, (ActorFuture<BrokerStartupContext>)future));
    }

    abstract void startupInternal(BrokerStartupContext var1, ConcurrencyControl var2, ActorFuture<BrokerStartupContext> var3);

    abstract void shutdownInternal(BrokerStartupContext var1, ConcurrencyControl var2, ActorFuture<BrokerStartupContext> var3);

    final ActorFuture<BrokerStartupContext> createFutureAndRun(BrokerStartupContext brokerStartupContext, BiConsumer<ConcurrencyControl, ActorFuture<BrokerStartupContext>> runnable) {
        try {
            ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
            ActorFuture future = concurrencyControl.createFuture();
            this.forwardExceptions(() -> runnable.accept(concurrencyControl, future), future);
            return future;
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
    }

    final <V> void forwardExceptions(Runnable r, ActorFuture<V> future) {
        try {
            r.run();
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)e);
        }
    }
}

