/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.bootstrap.BrokerContext;
import io.camunda.zeebe.broker.bootstrap.BrokerContextImpl;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStepMetricDecorator;
import io.camunda.zeebe.broker.bootstrap.ClusterServicesCreationStep;
import io.camunda.zeebe.broker.bootstrap.MonitoringServerStep;
import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetrics;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.startup.StartupProcess;
import io.camunda.zeebe.util.startup.StartupStep;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerStartupProcess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final List<StartupStep<BrokerStartupContext>> STARTUP_STEPS = List.of(new MonitoringServerStep(), new ClusterServicesCreationStep());
    private final StartupProcess<BrokerStartupContext> startupProcess;
    private BrokerStartupContext context;
    private final ConcurrencyControl concurrencyControl;

    public BrokerStartupProcess(BrokerStartupContext brokerStartupContext) {
        this.concurrencyControl = brokerStartupContext.getConcurrencyControl();
        this.context = brokerStartupContext;
        BrokerStepMetrics brokerStepMetrics = new BrokerStepMetrics();
        List decoratedSteps = STARTUP_STEPS.stream().map(step -> new BrokerStepMetricDecorator(brokerStepMetrics, (StartupStep<BrokerStartupContext>)step)).collect(Collectors.toList());
        this.startupProcess = new StartupProcess(LOG, decoratedSteps);
    }

    public ActorFuture<BrokerContext> start() {
        ActorFuture result = this.concurrencyControl.createFuture();
        ActorFuture startupFuture = this.startupProcess.startup(this.concurrencyControl, (Object)this.context);
        this.concurrencyControl.runOnCompletion(startupFuture, (bsc, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
            } else {
                this.context = bsc;
                result.complete((Object)this.createBrokerContext((BrokerStartupContext)bsc));
            }
        });
        return result;
    }

    public ActorFuture<Void> stop() {
        ActorFuture result = this.concurrencyControl.createFuture();
        ActorFuture shutdownFuture = this.startupProcess.shutdown(this.concurrencyControl, (Object)this.context);
        this.concurrencyControl.runOnCompletion(shutdownFuture, (bsc, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    private BrokerContext createBrokerContext(BrokerStartupContext bsc) {
        return new BrokerContextImpl(bsc.getClusterServices(), bsc.getPartitionListeners());
    }
}

