/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

final class MonitoringServerStep
extends AbstractBrokerStartupStep {
    MonitoringServerStep() {
    }

    public String getName() {
        return "monitoring services";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerHealthCheckService healthCheckService = brokerStartupContext.getHealthCheckService();
        concurrencyControl.runOnCompletion(brokerStartupContext.scheduleActor(healthCheckService), (ok, error) -> this.forwardExceptions(() -> this.completeStartup(brokerStartupContext, startupFuture, healthCheckService, (Throwable)error), startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        BrokerHealthCheckService healthCheckService = brokerShutdownContext.getHealthCheckService();
        SpringBrokerBridge springBrokerBridge = brokerShutdownContext.getSpringBrokerBridge();
        springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> null);
        brokerShutdownContext.removePartitionListener(healthCheckService);
        concurrencyControl.runOnCompletion(healthCheckService.closeAsync(), (ok, error) -> this.forwardExceptions(() -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                shutdownFuture.complete((Object)brokerShutdownContext);
            }
        }, shutdownFuture));
    }

    private void completeStartup(BrokerStartupContext brokerStartupContext, ActorFuture<BrokerStartupContext> startupFuture, BrokerHealthCheckService healthCheckService, Throwable error) {
        if (error != null) {
            startupFuture.completeExceptionally(error);
        } else {
            SpringBrokerBridge springBrokerBridge = brokerStartupContext.getSpringBrokerBridge();
            springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> healthCheckService);
            brokerStartupContext.addPartitionListener(healthCheckService);
            startupFuture.complete((Object)brokerStartupContext);
        }
    }
}

