/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.distribution;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.PartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedDistributionMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FixedPartitionDistributor
implements PartitionDistributor {
    private final Map<PartitionId, Set<FixedDistributionMember>> distribution;

    FixedPartitionDistributor(Map<PartitionId, Set<FixedDistributionMember>> distribution) {
        this.distribution = distribution;
    }

    public Set<PartitionMetadata> distributePartitions(Set<MemberId> clusterMembers, List<PartitionId> sortedPartitionIds, int replicationFactor) {
        HashSet<PartitionMetadata> partitions = new HashSet<PartitionMetadata>();
        for (PartitionId partitionId : sortedPartitionIds) {
            PartitionMetadata metadata = this.createPartitionMetadata(clusterMembers, replicationFactor, partitionId);
            partitions.add(metadata);
        }
        return partitions;
    }

    private PartitionMetadata createPartitionMetadata(Set<MemberId> clusterMembers, int replicationFactor, PartitionId partitionId) {
        ArrayList<MemberId> members = new ArrayList<MemberId>();
        HashMap<MemberId, Integer> priorities = new HashMap<MemberId, Integer>();
        Set<FixedDistributionMember> configuredMembers = this.distribution.get(partitionId);
        int targetPriority = 0;
        if (configuredMembers == null) {
            throw new IllegalStateException(String.format("Expected to distribute partition %d, but no members configured for it", partitionId.id()));
        }
        for (FixedDistributionMember member : configuredMembers) {
            members.add(member.getId());
            priorities.put(member.getId(), member.getPriority());
            targetPriority = Math.max(targetPriority, member.getPriority());
        }
        this.ensureMembersArePartOfCluster(clusterMembers, partitionId, members);
        this.ensurePartitionIsFullyReplicated(replicationFactor, partitionId, members);
        return new PartitionMetadata(partitionId, members, priorities, targetPriority);
    }

    private void ensureMembersArePartOfCluster(Set<MemberId> clusterMembers, PartitionId partitionId, ArrayList<MemberId> members) {
        if (!clusterMembers.containsAll(members)) {
            HashSet<MemberId> unknownMembers = new HashSet<MemberId>(members);
            unknownMembers.removeAll(clusterMembers);
            throw new IllegalStateException(String.format("Expected partition %d to be replicated across a cluster made of members %s, but the following configured members %s are not part of the cluster", partitionId.id(), clusterMembers, unknownMembers));
        }
    }

    private void ensurePartitionIsFullyReplicated(int replicationFactor, PartitionId partitionId, ArrayList<MemberId> members) {
        if (members.size() != replicationFactor) {
            throw new IllegalStateException(String.format("Expected each partition to be replicated across exactly %d members, but partition %d is replicated across members %s", replicationFactor, partitionId.id(), members));
        }
    }
}

