/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;

public class LogStreamPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionStartupAndTransitionContextImpl context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        AtomixLogStorage logStorage = context.getLogStorage();
        this.buildLogstream(context, logStorage).onComplete((logStream, err) -> {
            if (err == null) {
                context.setLogStream((LogStream)logStream);
                context.getComponentHealthMonitor().registerComponent(logStream.getLogName(), (HealthMonitorable)logStream);
                openFuture.complete(null);
            } else {
                openFuture.completeExceptionally(err);
            }
        });
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionStartupAndTransitionContextImpl context) {
        context.getComponentHealthMonitor().removeComponent(context.getLogStream().getLogName());
        ActorFuture future = context.getLogStream().closeAsync();
        context.setLogStream(null);
        return future;
    }

    @Override
    public String getName() {
        return "logstream";
    }

    private ActorFuture<LogStream> buildLogstream(PartitionStartupAndTransitionContextImpl context, AtomixLogStorage atomixLogStorage) {
        return LogStream.builder().withLogStorage((LogStorage)atomixLogStorage).withLogName("logstream-" + context.getRaftPartition().name()).withNodeId(context.getNodeId()).withPartitionId(((Integer)context.getRaftPartition().id().id()).intValue()).withMaxFragmentSize(context.getMaxFragmentSize()).withActorSchedulingService(context.getActorSchedulingService()).buildAsync();
    }
}

