/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.system.configuration.QueryApiCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiRequestHandler;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.broker.transport.commandapi.CommandResponseWriterImpl;
import io.camunda.zeebe.broker.transport.commandapi.QueryApiRequestHandler;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.Consumer;
import org.agrona.collections.IntHashSet;

public final class CommandApiServiceImpl
extends Actor
implements PartitionListener,
DiskSpaceUsageListener,
CommandApiService {
    private final PartitionAwareRequestLimiter limiter;
    private final ServerTransport serverTransport;
    private final CommandApiRequestHandler commandHandler;
    private final QueryApiRequestHandler queryHandler;
    private final IntHashSet leadPartitions = new IntHashSet();
    private final String actorName;
    private final ActorSchedulingService scheduler;

    public CommandApiServiceImpl(ServerTransport serverTransport, BrokerInfo localBroker, PartitionAwareRequestLimiter limiter, ActorSchedulingService scheduler, QueryApiCfg queryApiCfg) {
        this.serverTransport = serverTransport;
        this.limiter = limiter;
        this.scheduler = scheduler;
        this.commandHandler = new CommandApiRequestHandler();
        this.queryHandler = new QueryApiRequestHandler(queryApiCfg, localBroker.getNodeId());
        this.actorName = CommandApiServiceImpl.buildActorName((int)localBroker.getNodeId(), (String)"CommandApiService");
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.scheduler.submitActor((Actor)this.queryHandler);
    }

    protected void onActorClosing() {
        for (Integer leadPartition : this.leadPartitions) {
            this.removeLeaderHandlers(leadPartition);
        }
        this.leadPartitions.clear();
        this.actor.runOnCompletion(this.queryHandler.closeAsync(), (ok, error) -> {
            if (error != null) {
                Loggers.TRANSPORT_LOGGER.warn("Failed to close query API request handler", error);
            }
        });
    }

    @Override
    public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
        return this.removeLeaderHandlersAsync(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream, QueryService queryService) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            this.leadPartitions.add(partitionId);
            this.limiter.addPartition(partitionId);
            this.queryHandler.addPartition(partitionId, queryService);
            this.serverTransport.subscribe(partitionId, RequestType.QUERY, (RequestHandler)this.queryHandler);
            logStream.newLogStreamRecordWriter().onComplete((recordWriter, error) -> {
                if (error == null) {
                    RequestLimiter<Intent> requestLimiter = this.limiter.getLimiter(partitionId);
                    this.commandHandler.addPartition(partitionId, (LogStreamRecordWriter)recordWriter, requestLimiter);
                    this.serverTransport.subscribe(partitionId, RequestType.COMMAND, (RequestHandler)this.commandHandler);
                    future.complete(null);
                } else {
                    Loggers.SYSTEM_LOGGER.error("Error on retrieving write buffer from log stream {}", (Object)partitionId, error);
                    future.completeExceptionally(error);
                }
            });
        });
        return future;
    }

    @Override
    public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
        return this.removeLeaderHandlersAsync(partitionId);
    }

    private ActorFuture<Void> removeLeaderHandlersAsync(int partitionId) {
        return this.actor.call(() -> this.removeLeaderHandlers(partitionId));
    }

    private void removeLeaderHandlers(int partitionId) {
        this.commandHandler.removePartition(partitionId);
        this.queryHandler.removePartition(partitionId);
        this.cleanLeadingPartition(partitionId);
    }

    private void cleanLeadingPartition(int partitionId) {
        this.leadPartitions.remove(partitionId);
        this.removeForPartitionId(partitionId);
    }

    private void removeForPartitionId(int partitionId) {
        this.limiter.removePartition(partitionId);
        this.serverTransport.unsubscribe(partitionId);
    }

    @Override
    public CommandResponseWriter newCommandResponseWriter() {
        return new CommandResponseWriterImpl((ServerOutput)this.serverTransport);
    }

    @Override
    public Consumer<TypedRecord<?>> getOnProcessedListener(int partitionId) {
        RequestLimiter<Intent> partitionLimiter = this.limiter.getLimiter(partitionId);
        return typedRecord -> {
            if (typedRecord.getRecordType() == RecordType.COMMAND && typedRecord.hasRequestMetadata()) {
                partitionLimiter.onResponse(typedRecord.getRequestStreamId(), typedRecord.getRequestId());
            }
        };
    }

    @Override
    public void onDiskSpaceNotAvailable() {
        this.actor.run(this.commandHandler::onDiskSpaceNotAvailable);
    }

    @Override
    public void onDiskSpaceAvailable() {
        this.actor.run(this.commandHandler::onDiskSpaceAvailable);
    }
}

