/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.protocol.record.ExecuteQueryResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class QueryResponseWriter
implements BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ExecuteQueryResponseEncoder responseEncoder = new ExecuteQueryResponseEncoder();
    private final ServerResponseImpl response = new ServerResponseImpl();
    private final DirectBuffer bpmnProcessId = new UnsafeBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryWriteResponse(ServerOutput output, int partitionId, long requestId) {
        try {
            this.response.reset().writer((BufferWriter)this).setPartitionId(partitionId).setRequestId(requestId);
            output.sendResponse((ServerResponse)this.response);
        }
        finally {
            this.reset();
        }
    }

    public int getLength() {
        return 8 + ExecuteQueryResponseEncoder.bpmnProcessIdHeaderLength() + this.bpmnProcessId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset);
        this.headerEncoder.blockLength(this.responseEncoder.sbeBlockLength()).templateId(this.responseEncoder.sbeTemplateId()).schemaId(this.responseEncoder.sbeSchemaId()).version(this.responseEncoder.sbeSchemaVersion());
        this.responseEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength());
        this.responseEncoder.putBpmnProcessId(this.bpmnProcessId, 0, this.bpmnProcessId.capacity());
    }

    public void reset() {
        this.bpmnProcessId.wrap(0L, 0);
    }

    public QueryResponseWriter bpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessId.wrap(bpmnProcessId);
        return this;
    }
}

