/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.debug;

import io.camunda.zeebe.broker.exporter.debug.DebugHttpServer;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.Record;
import org.slf4j.Logger;

public final class DebugHttpExporter
implements Exporter {
    private static DebugHttpServer httpServer;
    private Logger log;

    public void configure(Context context) {
        this.log = context.getLogger();
        this.initHttpServer(context);
    }

    public void close() {
        this.stopHttpServer();
    }

    public void export(Record<?> record) {
        try {
            httpServer.add(record);
        }
        catch (Exception e) {
            this.log.warn("Failed to serialize record {} to json", record, (Object)e);
        }
    }

    private synchronized void initHttpServer(Context context) {
        if (httpServer == null) {
            DebugHttpExporterConfiguration configuration = (DebugHttpExporterConfiguration)context.getConfiguration().instantiate(DebugHttpExporterConfiguration.class);
            httpServer = new DebugHttpServer(configuration.getPort(), configuration.getLimit());
            this.log.info("Debug http server started, inspect the last {} records on http://localhost:{}", (Object)configuration.getLimit(), (Object)configuration.getPort());
        }
    }

    public synchronized void stopHttpServer() {
        if (httpServer != null) {
            httpServer.close();
            httpServer = null;
        }
    }

    public static ExporterCfg defaultConfig() {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setClassName(DebugHttpExporter.class.getName());
        return exporterCfg;
    }

    public static class DebugHttpExporterConfiguration {
        private int port = 8000;
        private int limit = 1024;

        private int getPort() {
            return this.port;
        }

        private void setPort(int port) {
            this.port = port;
        }

        private int getLimit() {
            return this.limit;
        }

        private void setLimit(int limit) {
            this.limit = limit;
        }
    }
}

