/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import java.util.Optional;
import org.springframework.util.unit.DataSize;

public final class NetworkCfg
implements ConfigurationEntry {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_COMMAND_API_PORT = 26501;
    public static final int DEFAULT_INTERNAL_API_PORT = 26502;
    public static final int DEFAULT_MONITORING_API_PORT = 9600;
    public static final DataSize DEFAULT_MAX_MESSAGE_SIZE = DataSize.ofMegabytes((long)4L);
    private String host = "0.0.0.0";
    private int portOffset = 0;
    private DataSize maxMessageSize = DEFAULT_MAX_MESSAGE_SIZE;
    private String advertisedHost;
    private final SocketBindingCfg.CommandApiCfg commandApi = new SocketBindingCfg.CommandApiCfg();
    private SocketBindingCfg.InternalApiCfg internalApi = new SocketBindingCfg.InternalApiCfg();
    private SocketBindingCfg.MonitoringApiCfg monitoringApi = new SocketBindingCfg.MonitoringApiCfg();

    @Override
    public void init(BrokerCfg brokerCfg, String brokerBase) {
        this.applyDefaults();
    }

    public void applyDefaults() {
        this.commandApi.applyDefaults(this);
        this.internalApi.applyDefaults(this);
        this.monitoringApi.applyDefaults(this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAdvertisedHost() {
        return Optional.ofNullable(this.advertisedHost).orElse(this.getHost());
    }

    public void setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public long getMaxMessageSizeInBytes() {
        return this.maxMessageSize.toBytes();
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public SocketBindingCfg.CommandApiCfg getCommandApi() {
        return this.commandApi;
    }

    public SocketBindingCfg getMonitoringApi() {
        return this.monitoringApi;
    }

    public void setMonitoringApi(SocketBindingCfg.MonitoringApiCfg monitoringApi) {
        this.monitoringApi = monitoringApi;
    }

    public SocketBindingCfg getInternalApi() {
        return this.internalApi;
    }

    public void setInternalApi(SocketBindingCfg.InternalApiCfg internalApi) {
        this.internalApi = internalApi;
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + "', portOffset=" + this.portOffset + "', maxMessageSize=" + this.maxMessageSize + ", commandApi=" + this.commandApi + ", internalApi=" + this.internalApi + ", monitoringApi=" + this.monitoringApi + "}";
    }
}

