/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.SnapshotReplicationListener;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.HealthMetrics;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.broker.system.partitions.PartitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.RoleMetrics;
import io.camunda.zeebe.broker.system.partitions.ZeebePartitionAdminAccess;
import io.camunda.zeebe.broker.system.partitions.ZeebePartitionHealth;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.CriticalComponentsHealthMonitor;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitor;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import io.camunda.zeebe.util.startup.StartupProcess;
import io.camunda.zeebe.util.startup.StartupStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public final class ZeebePartition
extends Actor
implements RaftRoleChangeListener,
HealthMonitorable,
FailureListener,
DiskSpaceUsageListener,
SnapshotReplicationListener {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final StartupProcess<PartitionStartupContext> startupProcess;
    private RaftServer.Role raftRole;
    private final String actorName;
    private final List<FailureListener> failureListeners;
    private final HealthMetrics healthMetrics;
    private final RoleMetrics roleMetrics;
    private final ZeebePartitionHealth zeebePartitionHealth;
    private PartitionContext context;
    private PartitionStartupContext startupContext;
    private final PartitionAdminControl adminControl;
    private final PartitionTransition transition;
    private CompletableActorFuture<Void> closeFuture;
    private ActorFuture<Void> currentTransitionFuture;
    private final boolean newTransitionLogicEnabled;

    public ZeebePartition(PartitionStartupAndTransitionContextImpl transitionContext, PartitionTransition transition, List<StartupStep<PartitionStartupContext>> startupSteps) {
        this.context = transitionContext.getPartitionContext();
        this.adminControl = transitionContext.getPartitionAdminControl();
        this.transition = transition;
        this.startupContext = transitionContext;
        this.startupProcess = new StartupProcess(LOG, startupSteps);
        transitionContext.setActorControl(this.actor);
        transitionContext.setDiskSpaceAvailable(true);
        this.newTransitionLogicEnabled = transitionContext.getBrokerCfg().getExperimental().isNewTransitionLogicEnabled();
        if (this.newTransitionLogicEnabled) {
            transition.setConcurrencyControl((ConcurrencyControl)this.actor);
        }
        this.actorName = ZeebePartition.buildActorName((int)transitionContext.getNodeId(), (String)"ZeebePartition", (int)transitionContext.getPartitionId());
        transitionContext.setComponentHealthMonitor((HealthMonitor)new CriticalComponentsHealthMonitor(this.actor, LOG));
        this.zeebePartitionHealth = new ZeebePartitionHealth(transitionContext.getPartitionId());
        this.healthMetrics = new HealthMetrics(transitionContext.getPartitionId());
        this.healthMetrics.setUnhealthy();
        this.failureListeners = new ArrayList<FailureListener>();
        this.roleMetrics = new RoleMetrics(transitionContext.getPartitionId());
    }

    public PartitionAdminAccess createAdminAccess() {
        return new ZeebePartitionAdminAccess((ConcurrencyControl)this.actor, this.adminControl);
    }

    protected Map<String, String> createContext() {
        Map actorContext = super.createContext();
        actorContext.put("partitionId", Integer.toString(this.context.getPartitionId()));
        return actorContext;
    }

    public String getName() {
        return this.actorName;
    }

    public void onActorStarting() {
        if (this.newTransitionLogicEnabled) {
            this.startupProcess.startup((ConcurrencyControl)this.actor, (Object)this.startupContext).onComplete((newStartupContext, error) -> {
                if (error != null) {
                    LOG.error(error.getMessage(), error);
                    this.handleUnrecoverableFailure();
                    this.close();
                    return;
                }
                this.startupContext = newStartupContext;
                PartitionStartupAndTransitionContextImpl transitionContext = this.startupContext.createTransitionContext();
                this.transition.updateTransitionContext(transitionContext);
                this.context = transitionContext.getPartitionContext();
                this.registerListenersAndTriggerRoleChange();
            });
        } else {
            this.registerListenersAndTriggerRoleChange();
        }
    }

    protected void onActorStarted() {
        this.context.getComponentHealthMonitor().startMonitoring();
        this.context.getComponentHealthMonitor().registerComponent(this.context.getRaftPartition().name(), (HealthMonitorable)this.context.getRaftPartition());
        this.context.getComponentHealthMonitor().registerComponent(this.zeebePartitionHealth.getName(), (HealthMonitorable)this.zeebePartitionHealth);
    }

    protected void onActorClosing() {
        this.context.getRaftPartition().getServer().removeSnapshotReplicationListener((SnapshotReplicationListener)this);
        this.context.getRaftPartition().removeRoleChangeListener((RaftRoleChangeListener)this);
        this.transitionToInactive().onComplete((nothing, err) -> {
            this.context.getComponentHealthMonitor().removeComponent(this.context.getRaftPartition().name());
            if (this.newTransitionLogicEnabled) {
                this.startupProcess.shutdown((ConcurrencyControl)this.actor, (Object)this.startupContext).onComplete((newStartupContext, error) -> {
                    if (error != null) {
                        LOG.error(error.getMessage(), error);
                    }
                    this.startupContext = null;
                    this.context = null;
                    this.closeFuture.complete(null);
                });
            } else {
                this.closeFuture.complete(null);
            }
        });
    }

    protected void onActorCloseRequested() {
        LOG.debug("Closing ZeebePartition {}", (Object)this.context.getPartitionId());
        this.context.getComponentHealthMonitor().removeComponent(this.zeebePartitionHealth.getName());
    }

    public ActorFuture<Void> closeAsync() {
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.closeFuture = new CompletableActorFuture();
        this.actor.run(() -> this.currentTransitionFuture.onComplete((nothing, err) -> super.closeAsync()));
        return this.closeFuture;
    }

    protected void handleFailure(Exception failure) {
        LOG.warn("Uncaught exception in {}.", (Object)this.actorName, (Object)failure);
        this.onInstallFailure(failure);
    }

    @Deprecated
    public void onNewRole(RaftServer.Role newRole, long newTerm) {
        this.actor.run(() -> this.onRoleChange(newRole, newTerm));
    }

    private void onRoleChange(RaftServer.Role newRole, long newTerm) {
        ActorFuture<Void> nextTransitionFuture = null;
        switch (newRole) {
            case LEADER: {
                if (this.raftRole == RaftServer.Role.LEADER) break;
                nextTransitionFuture = this.leaderTransition(newTerm);
                break;
            }
            case INACTIVE: {
                nextTransitionFuture = this.transitionToInactive();
                break;
            }
            default: {
                if (this.raftRole != null && this.raftRole != RaftServer.Role.LEADER) break;
                nextTransitionFuture = this.followerTransition(newTerm);
            }
        }
        if (nextTransitionFuture != null) {
            this.currentTransitionFuture = nextTransitionFuture;
        }
        LOG.debug("Partition role transitioning from {} to {} in term {}", new Object[]{this.raftRole, newRole, newTerm});
        this.raftRole = newRole;
    }

    private ActorFuture<Void> leaderTransition(long newTerm) {
        long installStartTime = ActorClock.currentTimeMillis();
        ActorFuture<Void> leaderTransitionFuture = this.transition.toLeader(newTerm);
        leaderTransitionFuture.onComplete((success, error) -> {
            if (error == null) {
                long leaderTransitionLatency = ActorClock.currentTimeMillis() - installStartTime;
                this.roleMetrics.setLeaderTransitionLatency(leaderTransitionLatency);
                List<ActorFuture<Void>> listenerFutures = this.context.notifyListenersOfBecomingLeader(newTerm);
                this.actor.runOnCompletion(listenerFutures, t -> {
                    if (t != null) {
                        this.onInstallFailure((Throwable)t);
                    }
                });
                this.onRecoveredInternal();
            } else {
                LOG.error("Failed to install leader partition {}", (Object)this.context.getPartitionId(), error);
                this.onInstallFailure((Throwable)error);
            }
        });
        return leaderTransitionFuture;
    }

    private ActorFuture<Void> followerTransition(long newTerm) {
        ActorFuture<Void> followerTransitionFuture = this.transition.toFollower(newTerm);
        followerTransitionFuture.onComplete((success, error) -> {
            if (error == null) {
                List<ActorFuture<Void>> listenerFutures = this.context.notifyListenersOfBecomingFollower(newTerm);
                this.actor.runOnCompletion(listenerFutures, t -> {
                    if (t != null) {
                        this.onInstallFailure((Throwable)t);
                    }
                });
                this.onRecoveredInternal();
            } else {
                LOG.error("Failed to install follower partition {}", (Object)this.context.getPartitionId(), error);
                this.onInstallFailure((Throwable)error);
            }
        });
        return followerTransitionFuture;
    }

    private ActorFuture<Void> transitionToInactive() {
        this.zeebePartitionHealth.setServicesInstalled(false);
        ActorFuture<Void> inactiveTransitionFuture = this.transition.toInactive();
        this.currentTransitionFuture = inactiveTransitionFuture;
        return inactiveTransitionFuture;
    }

    private void registerListenersAndTriggerRoleChange() {
        this.context.getRaftPartition().addRoleChangeListener((RaftRoleChangeListener)this);
        this.context.getComponentHealthMonitor().addFailureListener((FailureListener)this);
        this.onRoleChange(this.context.getRaftPartition().getRole(), this.context.getRaftPartition().term());
        this.context.getRaftPartition().getServer().addSnapshotReplicationListener((SnapshotReplicationListener)this);
    }

    @Deprecated
    public void onFailure() {
        this.actor.run(() -> {
            this.healthMetrics.setUnhealthy();
            this.failureListeners.forEach(FailureListener::onFailure);
        });
    }

    @Deprecated
    public void onRecovered() {
        this.actor.run(() -> {
            this.healthMetrics.setHealthy();
            this.failureListeners.forEach(FailureListener::onRecovered);
        });
    }

    @Deprecated
    public void onUnrecoverableFailure() {
        this.actor.run(this::handleUnrecoverableFailure);
    }

    private void onInstallFailure(Throwable error) {
        if (error instanceof UnrecoverableException) {
            LOG.error("Failed to install partition {} (role {}, term {}) with unrecoverable failure: ", new Object[]{this.context.getPartitionId(), this.context.getCurrentRole(), this.context.getCurrentTerm(), error});
            this.handleUnrecoverableFailure();
        } else {
            this.handleRecoverableFailure();
        }
    }

    private void handleRecoverableFailure() {
        this.zeebePartitionHealth.setServicesInstalled(false);
        this.context.notifyListenersOfBecomingInactive();
        if (this.context.getCurrentRole() == RaftServer.Role.LEADER && this.context.getCurrentTerm() == this.context.getRaftPartition().term()) {
            LOG.info("Unexpected failure occurred in partition {} (role {}, term {}), stepping down", new Object[]{this.context.getPartitionId(), this.context.getCurrentRole(), this.context.getCurrentTerm()});
            this.context.getRaftPartition().stepDown();
        } else if (this.context.getCurrentRole() == RaftServer.Role.FOLLOWER) {
            LOG.info("Unexpected failure occurred in partition {} (role {}, term {}), transitioning to inactive", new Object[]{this.context.getPartitionId(), this.context.getCurrentRole(), this.context.getCurrentTerm()});
            this.context.getRaftPartition().goInactive();
        }
    }

    private void handleUnrecoverableFailure() {
        this.healthMetrics.setDead();
        this.zeebePartitionHealth.onUnrecoverableFailure();
        this.transitionToInactive();
        this.context.getRaftPartition().goInactive();
        this.failureListeners.forEach(FailureListener::onUnrecoverableFailure);
        this.context.notifyListenersOfBecomingInactive();
    }

    private void onRecoveredInternal() {
        this.zeebePartitionHealth.setServicesInstalled(true);
    }

    public HealthStatus getHealthStatus() {
        return this.context.getComponentHealthMonitor().getHealthStatus();
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> {
            this.failureListeners.add(failureListener);
            if (this.getHealthStatus() == HealthStatus.HEALTHY) {
                failureListener.onRecovered();
            } else {
                failureListener.onFailure();
            }
        });
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.remove(failureListener));
    }

    @Override
    @Deprecated
    public void onDiskSpaceNotAvailable() {
        this.actor.call(() -> {
            this.context.setDiskSpaceAvailable(false);
            this.zeebePartitionHealth.setDiskSpaceAvailable(false);
            if (this.context.getStreamProcessor() != null) {
                LOG.warn("Disk space usage is above threshold. Pausing stream processor.");
                this.context.getStreamProcessor().pauseProcessing();
            }
        });
    }

    @Override
    @Deprecated
    public void onDiskSpaceAvailable() {
        this.actor.call(() -> {
            this.context.setDiskSpaceAvailable(true);
            this.zeebePartitionHealth.setDiskSpaceAvailable(false);
            if (this.context.getStreamProcessor() != null && this.context.shouldProcess()) {
                LOG.info("Disk space usage is below threshold. Resuming stream processor.");
                this.context.getStreamProcessor().resumeProcessing();
            }
        });
    }

    public int getPartitionId() {
        return this.context.getPartitionId();
    }

    public PersistedSnapshotStore getSnapshotStore() {
        return this.context.getRaftPartition().getServer().getPersistedSnapshotStore();
    }

    public ActorFuture<Optional<StreamProcessor>> getStreamProcessor() {
        return this.actor.call(() -> Optional.ofNullable(this.context.getStreamProcessor()));
    }

    public ActorFuture<Optional<ExporterDirector>> getExporterDirector() {
        return this.actor.call(() -> Optional.ofNullable(this.context.getExporterDirector()));
    }

    public void onSnapshotReplicationStarted() {
        this.actor.run(() -> {
            this.currentTransitionFuture = this.transition.toInactive();
        });
    }

    public void onSnapshotReplicationCompleted(long term) {
        this.actor.run(() -> {
            this.currentTransitionFuture = this.followerTransition(term);
        });
    }

    public ActorFuture<RaftServer.Role> getCurrentRole() {
        return this.actor.call(() -> this.context.getCurrentRole());
    }
}

