/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.HashSet;
import java.util.Set;

class ZeebePartitionHealth
implements HealthMonitorable {
    private final String name;
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private HealthStatus healthStatus = HealthStatus.UNHEALTHY;
    private boolean servicesInstalled;
    private boolean diskSpaceAvailable = true;

    public ZeebePartitionHealth(int partitionId) {
        this.name = "ZeebePartition-" + partitionId;
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.failureListeners.add(failureListener);
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.failureListeners.remove(failureListener);
    }

    private void updateHealthStatus() {
        HealthStatus previousStatus = this.healthStatus;
        if (previousStatus == HealthStatus.DEAD) {
            return;
        }
        boolean healthy = this.diskSpaceAvailable && this.servicesInstalled;
        this.healthStatus = healthy ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
        if (previousStatus != this.healthStatus) {
            switch (this.healthStatus) {
                case HEALTHY: {
                    this.failureListeners.forEach(FailureListener::onRecovered);
                    break;
                }
                case UNHEALTHY: {
                    this.failureListeners.forEach(FailureListener::onFailure);
                    break;
                }
                case DEAD: {
                    this.failureListeners.forEach(FailureListener::onUnrecoverableFailure);
                    break;
                }
            }
        }
    }

    void setServicesInstalled(boolean servicesInstalled) {
        this.servicesInstalled = servicesInstalled;
        this.updateHealthStatus();
    }

    void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.diskSpaceAvailable = diskSpaceAvailable;
        this.updateHealthStatus();
    }

    void onUnrecoverableFailure() {
        this.healthStatus = HealthStatus.DEAD;
    }

    public String getName() {
        return this.name;
    }
}

