/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.nio.ByteBuffer;
import java.util.Optional;

public class LogStoragePartitionStep
implements PartitionStep {
    private static final String WRONG_TERM_ERROR_MSG = "Expected that current term '%d' is same as raft term '%d', but was not. Failing installation of 'LogStoragePartitionStep' on partition %d.";

    @Override
    public ActorFuture<Void> open(PartitionStartupAndTransitionContextImpl context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        Either<Exception, AtomixLogStorage> logStorageOrException = this.buildAtomixLogStorage(context);
        if (logStorageOrException.isRight()) {
            AtomixLogStorage logStorage = (AtomixLogStorage)logStorageOrException.get();
            context.setLogStorage(logStorage);
            context.getRaftPartition().getServer().addCommitListener((RaftCommitListener)logStorage);
            openFuture.complete(null);
        } else {
            openFuture.completeExceptionally((Throwable)logStorageOrException.getLeft());
        }
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionStartupAndTransitionContextImpl context) {
        AtomixLogStorage logStorage = context.getLogStorage();
        if (logStorage != null) {
            context.getRaftPartition().getServer().removeCommitListener((RaftCommitListener)logStorage);
            context.setLogStorage(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "logstorage";
    }

    private Either<Exception, AtomixLogStorage> buildAtomixLogStorage(PartitionStartupAndTransitionContextImpl context) {
        RaftPartitionServer server = context.getRaftPartition().getServer();
        if (context.getCurrentRole() == RaftServer.Role.LEADER) {
            return this.createWritableLogStorage(context, server);
        }
        return this.createReadOnlyStorage(server);
    }

    private Either<Exception, AtomixLogStorage> createReadOnlyStorage(RaftPartitionServer server) {
        return Either.right((Object)new AtomixLogStorage(() -> ((RaftPartitionServer)server).openReader(), (ZeebeLogAppender)new LogAppenderForReadOnlyStorage()));
    }

    private Either<Exception, AtomixLogStorage> createWritableLogStorage(PartitionStartupAndTransitionContextImpl context, RaftPartitionServer server) {
        Optional appenderOptional = server.getAppender();
        return appenderOptional.map(logAppender -> this.checkAndCreateAtomixLogStorage(context, server, (ZeebeLogAppender)logAppender)).orElseGet(() -> Either.left((Object)new IllegalStateException("Not leader of partition " + context.getPartitionId())));
    }

    private Either<Exception, AtomixLogStorage> checkAndCreateAtomixLogStorage(PartitionStartupAndTransitionContextImpl context, RaftPartitionServer server, ZeebeLogAppender logAppender) {
        long raftTerm = server.getTerm();
        if (raftTerm != context.getCurrentTerm()) {
            return Either.left((Object)this.buildWrongTermException(context, raftTerm));
        }
        AtomixLogStorage logStorage = AtomixLogStorage.ofPartition(() -> ((RaftPartitionServer)server).openReader(), (ZeebeLogAppender)logAppender);
        return Either.right((Object)logStorage);
    }

    private IllegalStateException buildWrongTermException(PartitionStartupAndTransitionContextImpl context, long raftTerm) {
        return new IllegalStateException(String.format(WRONG_TERM_ERROR_MSG, context.getCurrentTerm(), raftTerm, context.getPartitionId()));
    }

    private static class LogAppenderForReadOnlyStorage
    implements ZeebeLogAppender {
        private LogAppenderForReadOnlyStorage() {
        }

        public void appendEntry(long lowestPosition, long highestPosition, ByteBuffer data, ZeebeLogAppender.AppendListener appendListener) {
            throw new UnsupportedOperationException(String.format("Expect to append entry (positions %d - %d), but was in Follower role. Followers must not append entries to the log storage", lowestPosition, highestPosition));
        }
    }
}

