/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftCommittedEntryListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;

public class SnapshotDirectorPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionStartupAndTransitionContextImpl context) {
        RaftPartitionServer server = context.getRaftPartition().getServer();
        Duration snapshotPeriod = context.getBrokerCfg().getData().getSnapshotPeriod();
        AsyncSnapshotDirector director = context.getCurrentRole() == RaftServer.Role.LEADER ? this.createSnapshotDirectorOfLeader(context, server, snapshotPeriod) : this.createSnapshotDirectorOfFollower(context, snapshotPeriod);
        context.setSnapshotDirector(director);
        context.getComponentHealthMonitor().registerComponent(director.getName(), (HealthMonitorable)director);
        return context.getActorSchedulingService().submitActor((Actor)director);
    }

    @Override
    public ActorFuture<Void> close(PartitionStartupAndTransitionContextImpl context) {
        AsyncSnapshotDirector director = context.getSnapshotDirector();
        context.getComponentHealthMonitor().removeComponent(director.getName());
        context.getRaftPartition().getServer().removeCommittedEntryListener((RaftCommittedEntryListener)director);
        ActorFuture<Void> future = director.closeAsync();
        context.setSnapshotDirector(null);
        return future;
    }

    @Override
    public String getName() {
        return "AsyncSnapshotDirector";
    }

    private AsyncSnapshotDirector createSnapshotDirectorOfLeader(PartitionStartupAndTransitionContextImpl context, RaftPartitionServer server, Duration snapshotPeriod) {
        AsyncSnapshotDirector director = AsyncSnapshotDirector.ofProcessingMode(context.getNodeId(), context.getPartitionId(), context.getStreamProcessor(), context.getStateController(), snapshotPeriod);
        server.addCommittedEntryListener((RaftCommittedEntryListener)director);
        return director;
    }

    private AsyncSnapshotDirector createSnapshotDirectorOfFollower(PartitionStartupAndTransitionContextImpl context, Duration snapshotPeriod) {
        AsyncSnapshotDirector director = AsyncSnapshotDirector.ofReplayMode(context.getNodeId(), context.getPartitionId(), context.getStreamProcessor(), context.getStateController(), snapshotPeriod);
        return director;
    }
}

