/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.logstreams.LogCompactor;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotListener;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.util.sched.Actor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class LogDeletionService
extends Actor
implements PersistedSnapshotListener {
    private final LogCompactor logCompactor;
    private final String actorName;
    private final Collection<PersistedSnapshotStore> persistedSnapshotStores;
    private final int partitionId;

    public LogDeletionService(int nodeId, int partitionId, LogCompactor logCompactor, Collection<PersistedSnapshotStore> persistedSnapshotStores) {
        this.persistedSnapshotStores = persistedSnapshotStores;
        this.logCompactor = logCompactor;
        this.actorName = LogDeletionService.buildActorName((int)nodeId, (String)"DeletionService", (int)partitionId);
        this.partitionId = partitionId;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.persistedSnapshotStores.forEach(store -> store.addSnapshotListener((PersistedSnapshotListener)this));
    }

    protected void onActorClosing() {
        this.persistedSnapshotStores.forEach(store -> store.removeSnapshotListener((PersistedSnapshotListener)this));
    }

    public void onNewSnapshot(PersistedSnapshot newPersistedSnapshot) {
        this.actor.run(() -> this.delegateDeletion(newPersistedSnapshot));
    }

    private void delegateDeletion(PersistedSnapshot persistedSnapshot) {
        long compactionBound = persistedSnapshot.getCompactionBound();
        ((CompletableFuture)this.logCompactor.compactLog(compactionBound).exceptionally(error -> this.logCompactionError(compactionBound, (Throwable)error))).join();
    }

    private Void logCompactionError(long compactionBound, Throwable error) {
        if (error != null) {
            Loggers.DELETION_SERVICE.error("Failed to compact Atomix log up to index {}", (Object)compactionBound, (Object)error);
        }
        return null;
    }
}

