/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthStatus;

public final class PartitionHealthBroadcaster
implements FailureListener {
    private final Integer partitionId;
    private final PartitionHealthListener delegate;

    public PartitionHealthBroadcaster(Integer partitionId, PartitionHealthListener delegate) {
        this.partitionId = partitionId;
        this.delegate = delegate;
    }

    public void onFailure() {
        this.delegate.onHealthChanged(this.partitionId, HealthStatus.UNHEALTHY);
    }

    public void onRecovered() {
        this.delegate.onHealthChanged(this.partitionId, HealthStatus.HEALTHY);
    }

    public void onUnrecoverableFailure() {
        this.delegate.onHealthChanged(this.partitionId, HealthStatus.DEAD);
    }

    @FunctionalInterface
    public static interface PartitionHealthListener {
        public void onHealthChanged(int var1, HealthStatus var2);
    }
}

